/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.model;

import com.google.common.collect.ImmutableList;
import net.conczin.mca.client.model.VillagerEntityBaseModelMCA;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class VillagerEntityModelMCA<T extends LivingEntity>
extends VillagerEntityBaseModelMCA<T> {
    protected static final String BREASTPLATE = "breastplate";
    public final ModelPart breastsWear;
    public final ModelPart leftArmwear;
    public final ModelPart rightArmwear;
    public final ModelPart leftLegwear;
    public final ModelPart rightLegwear;
    public final ModelPart bodyWear;
    private boolean wearsHidden;

    public VillagerEntityModelMCA(ModelPart tree) {
        super(tree);
        this.bodyWear = tree.getChild("jacket");
        this.leftArmwear = tree.getChild("left_sleeve");
        this.rightArmwear = tree.getChild("right_sleeve");
        this.leftLegwear = tree.getChild("left_pants");
        this.rightLegwear = tree.getChild("right_pants");
        this.breastsWear = tree.getChild(BREASTPLATE);
    }

    public static MeshDefinition hairData(CubeDeformation dilation) {
        MeshDefinition modelData = VillagerEntityModelMCA.bodyData(dilation);
        PartDefinition root = modelData.getRoot();
        root.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, dilation.extend(0.3f)), PartPose.ZERO);
        return modelData;
    }

    public static MeshDefinition bodyData(CubeDeformation dilation) {
        return VillagerEntityModelMCA.bodyData(dilation, false);
    }

    public static MeshDefinition bodyData(CubeDeformation dilation, boolean slim) {
        MeshDefinition modelData = PlayerModel.createMesh((CubeDeformation)dilation, (boolean)slim);
        PartDefinition root = modelData.getRoot();
        root.addOrReplaceChild("breasts", VillagerEntityModelMCA.newBreasts(dilation, 0), PartPose.ZERO);
        root.addOrReplaceChild(BREASTPLATE, VillagerEntityModelMCA.newBreasts(dilation.extend(0.1f), 16), PartPose.ZERO);
        return modelData;
    }

    public static MeshDefinition armorData(CubeDeformation dilation) {
        MeshDefinition modelData = HumanoidModel.createMesh((CubeDeformation)dilation, (float)0.0f);
        PartDefinition root = modelData.getRoot();
        root.addOrReplaceChild("breasts", VillagerEntityModelMCA.newBreasts(dilation, 0), PartPose.ZERO);
        return modelData;
    }

    @Override
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.bodyWear, (Object)this.leftLegwear, (Object)this.rightLegwear, (Object)this.leftArmwear, (Object)this.rightArmwear);
    }

    @Override
    public Iterable<ModelPart> getBreastParts() {
        return ImmutableList.of((Object)this.breasts, (Object)this.breastsWear);
    }

    @Override
    public void setupAnim(T villager, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        super.setupAnim(villager, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
        this.leftLegwear.copyFrom(this.leftLeg);
        this.rightLegwear.copyFrom(this.rightLeg);
        this.leftArmwear.copyFrom(this.leftArm);
        this.rightArmwear.copyFrom(this.rightArm);
        this.bodyWear.copyFrom(this.body);
        this.breastsWear.copyFrom(this.breasts);
    }

    public void setAllVisible(boolean visible) {
        super.setAllVisible(visible);
        this.leftArmwear.visible = !this.wearsHidden && visible;
        this.rightArmwear.visible = !this.wearsHidden && visible;
        this.leftLegwear.visible = !this.wearsHidden && visible;
        this.rightLegwear.visible = !this.wearsHidden && visible;
        this.bodyWear.visible = !this.wearsHidden && visible;
    }

    public VillagerEntityModelMCA<T> hideWears() {
        this.wearsHidden = true;
        this.breastsWear.visible = false;
        this.leftArmwear.visible = false;
        this.rightArmwear.visible = false;
        this.leftLegwear.visible = false;
        this.rightLegwear.visible = false;
        this.bodyWear.visible = false;
        return this;
    }

    @Override
    public void copyPropertiesTo(HumanoidModel<T> target) {
        super.copyPropertiesTo(target);
        if (target instanceof VillagerEntityModelMCA) {
            this.copyAttributes((VillagerEntityModelMCA)target);
        }
    }

    private void copyAttributes(VillagerEntityModelMCA<T> target) {
        target.leftLegwear.copyFrom(this.leftLegwear);
        target.rightLegwear.copyFrom(this.rightLegwear);
        target.leftArmwear.copyFrom(this.leftArmwear);
        target.rightArmwear.copyFrom(this.rightArmwear);
        target.bodyWear.copyFrom(this.bodyWear);
        target.breastsWear.copyFrom(this.breastsWear);
    }

    public <M extends HumanoidModel<T>> void copyVisibility(M model) {
        this.head.visible = model.head.visible;
        this.hat.visible = model.head.visible;
        this.body.visible = model.body.visible;
        this.bodyWear.visible = model.body.visible;
        this.breasts.visible = model.body.visible;
        this.breastsWear.visible = model.body.visible;
        this.leftArm.visible = model.leftArm.visible;
        this.leftArmwear.visible = model.leftArm.visible;
        this.rightArm.visible = model.rightArm.visible;
        this.rightArmwear.visible = model.rightArm.visible;
        this.leftLeg.visible = model.leftLeg.visible;
        this.leftLegwear.visible = model.leftLeg.visible;
        this.rightLeg.visible = model.rightLeg.visible;
        this.rightLegwear.visible = model.rightLeg.visible;
    }
}

