/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.conczin.mca.block.TombstoneBlock;
import net.conczin.mca.util.localization.FlowingText;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TombstoneBlockEntityRenderer
implements BlockEntityRenderer<TombstoneBlock.Data> {
    private final Font text;

    public TombstoneBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.text = context.getFont();
    }

    public int getViewDistance() {
        return 32;
    }

    public void render(TombstoneBlock.Data entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (!entity.hasEntity()) {
            return;
        }
        BlockState state = entity.getBlockState();
        matrices.pushPose();
        matrices.translate(0.5, 0.5, 0.5);
        Direction facing = ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite();
        matrices.mulPose(Axis.YP.rotationDegrees(-facing.toYRot()));
        matrices.translate(0.0f, 0.0f, 0.0f);
        matrices.scale(0.010416667f, 0.010416667f, 0.010416667f);
        matrices.mulPose(Axis.ZP.rotationDegrees(180.0f));
        TombstoneBlock block = (TombstoneBlock)state.getBlock();
        matrices.mulPose(Axis.XP.rotationDegrees(block.getRotation()));
        Vec3 offset = block.getNameplateOffset();
        matrices.translate(offset.x(), offset.y(), offset.z());
        int maxLineWidth = block.getLineWidth();
        float y = this.drawText(this.text, this.text.split((FormattedText)Component.translatable((String)"block.mca.tombstone.header"), maxLineWidth), 0.0f, matrices, vertexConsumers, light);
        y += 5.0f;
        FlowingText name = entity.getOrCreateEntityName(n -> FlowingText.Factory.wrapLines(this.text, n, maxLineWidth, block.getMaxNameHeight()));
        matrices.pushPose();
        matrices.scale(name.scale(), name.scale(), name.scale());
        y = this.drawText(this.text, name.lines(), y / name.scale(), matrices, vertexConsumers, light) * name.scale();
        matrices.popPose();
        this.drawText(this.text, this.text.split((FormattedText)Component.translatable((String)("block.mca.tombstone.footer." + entity.getGender().binary().getDataName())), maxLineWidth), y += 5.0f, matrices, vertexConsumers, light);
        matrices.popPose();
    }

    private float drawText(Font text, List<FormattedCharSequence> lines, float y, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        for (FormattedCharSequence line : lines) {
            float x = (float)(-text.width(line)) / 2.0f;
            text.drawInBatch8xOutline(line, x, y, -1, -16777216, matrices.last().pose(), vertexConsumers, light);
            y += 10.0f;
        }
        return y;
    }
}

