/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity;

import java.util.Optional;
import java.util.Set;
import net.conczin.mca.Config;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.Infectable;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.DialogueType;
import net.conczin.mca.entity.ai.Genetics;
import net.conczin.mca.entity.ai.Messenger;
import net.conczin.mca.entity.ai.Traits;
import net.conczin.mca.entity.ai.brain.VillagerBrain;
import net.conczin.mca.entity.ai.relationship.AgeState;
import net.conczin.mca.entity.ai.relationship.EntityRelationship;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.entity.ai.relationship.VillagerDimensions;
import net.conczin.mca.entity.interaction.EntityCommandHandler;
import net.conczin.mca.registry.EntitiesMCA;
import net.conczin.mca.resources.ClothingList;
import net.conczin.mca.resources.HairList;
import net.conczin.mca.resources.Names;
import net.conczin.mca.server.world.data.FamilyTreeNode;
import net.conczin.mca.server.world.data.PlayerSaveData;
import net.conczin.mca.util.network.datasync.CDataManager;
import net.conczin.mca.util.network.datasync.CDataParameter;
import net.conczin.mca.util.network.datasync.CEnumParameter;
import net.conczin.mca.util.network.datasync.CParameter;
import net.conczin.mca.util.network.datasync.CTrackedEntity;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;

public interface VillagerLike<E extends Entity>
extends CTrackedEntity<E>,
VillagerDataHolder,
Infectable,
Messenger {
    public static final CDataParameter<String> CLOTHES;
    public static final CDataParameter<String> HAIR;
    public static final CDataParameter<Float> HAIR_COLOR_RED;
    public static final CDataParameter<Float> HAIR_COLOR_GREEN;
    public static final CDataParameter<Float> HAIR_COLOR_BLUE;
    public static final CEnumParameter<AgeState> AGE_STATE;
    public static final ResourceLocation SPEED_ID;
    public static final ResourceLocation DAMAGE_ID;

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(Class<E> type) {
        return new CDataManager.Builder<E>(type).addAll(CLOTHES, HAIR, HAIR_COLOR_RED, HAIR_COLOR_GREEN, HAIR_COLOR_BLUE, AGE_STATE).add(Genetics::createTrackedData).add(Traits::createTrackedData).add(VillagerBrain::createTrackedData);
    }

    public static VillagerLike<?> toVillager(PlayerSaveData player) {
        CompoundTag villagerData = player.getEntityData();
        VillagerEntityMCA villager = (VillagerEntityMCA)EntitiesMCA.MALE_VILLAGER.create((Level)player.getWorld());
        if (!1.$assertionsDisabled && villager == null) {
            throw new AssertionError();
        }
        villager.readAdditionalSaveData(villagerData);
        return villager;
    }

    public static VillagerLike<?> toVillager(Entity entity) {
        if (entity instanceof VillagerLike) {
            return (VillagerLike)entity;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer playerEntity = (ServerPlayer)entity;
            return VillagerLike.toVillager(PlayerSaveData.get(playerEntity));
        }
        return null;
    }

    public Genetics getGenetics();

    public Traits getTraits();

    public VillagerBrain<?> getVillagerBrain();

    public EntityCommandHandler<?> getInteractions();

    default public void initialize(MobSpawnType spawnReason) {
        if (spawnReason != MobSpawnType.CONVERSION) {
            if (spawnReason != MobSpawnType.BREEDING) {
                this.getGenetics().randomize();
                this.getTraits().randomize();
            }
            this.initializeSkin(false);
            this.getVillagerBrain().randomize();
        }
        if (this.getGenetics().getGender() == Gender.UNASSIGNED) {
            this.getGenetics().setGender(Gender.getRandom());
        }
        if (this.asEntity().getCustomName() == null) {
            this.asEntity().setCustomName((Component)Component.literal((String)Names.pickCitizenName(this.getGenetics().getGender(), (Entity)this.asEntity())));
        }
        this.validateClothes();
        this.asEntity().refreshDimensions();
    }

    @Override
    default public boolean isSpeechImpaired() {
        return this.getInfectionProgress() > 0.6f;
    }

    @Override
    default public boolean isToYoungToSpeak() {
        return this.getAgeState() == AgeState.BABY;
    }

    default public void setName(String name) {
        if (!this.asEntity().level().isClientSide) {
            EntityRelationship.of((Entity)this.asEntity()).ifPresent(relationship -> relationship.getFamilyEntry().setName(name));
        }
    }

    default public Set<Gender> getAttractedGenderSet(VillagerLike<?> villager) {
        if (villager.getTraits().hasTrait(Traits.BISEXUAL)) {
            return Set.of(Gender.MALE, Gender.FEMALE, Gender.NEUTRAL);
        }
        if (villager.getTraits().hasTrait(Traits.HOMOSEXUAL)) {
            return Set.of(villager.getGenetics().getGender(), Gender.NEUTRAL);
        }
        if (villager.getTraits().hasTrait(Traits.ASEXUAL)) {
            return Set.of(Gender.NEUTRAL);
        }
        return Set.of(villager.getGenetics().getGender().opposite(), Gender.NEUTRAL);
    }

    default public boolean canBeAttractedTo(VillagerLike<?> other) {
        return this.getAttractedGenderSet(this).contains((Object)other.getGenetics().getGender()) && this.getAttractedGenderSet(other).contains((Object)this.getGenetics().getGender());
    }

    default public boolean canBeAttractedTo(PlayerSaveData other) {
        return !Config.getInstance().enableGenderCheckForPlayers || this.canBeAttractedTo(VillagerLike.toVillager(other));
    }

    default public InteractionHand getDominantHand() {
        return this.getTraits().hasTrait(Traits.LEFT_HANDED) ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    default public InteractionHand getOpposingHand() {
        return this.getDominantHand() == InteractionHand.OFF_HAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    default public EquipmentSlot getDominantSlot() {
        return LivingEntity.getSlotForHand((InteractionHand)this.getDominantHand());
    }

    default public EquipmentSlot getOpposingSlot() {
        return LivingEntity.getSlotForHand((InteractionHand)this.getOpposingHand());
    }

    default public ResourceLocation getProfessionId() {
        return MCA.locate("none");
    }

    default public String getProfessionName() {
        String professionName = (this.getProfessionId().getNamespace().equalsIgnoreCase("minecraft") ? (this.getProfessionId().getPath().equals("none") ? "mca.none" : this.getProfessionId().getPath()) : this.getProfessionId().toString()).replace(":", ".");
        return MCA.isBlankString(professionName) ? "mca.none" : professionName;
    }

    default public MutableComponent getProfessionText() {
        return Component.translatable((String)("entity.minecraft.villager." + this.getProfessionName()));
    }

    default public boolean isProfessionImportant() {
        return false;
    }

    default public boolean requiresHome() {
        return false;
    }

    default public boolean canTradeWithProfession() {
        return false;
    }

    default public String getClothes() {
        return (String)this.getTrackedValue(CLOTHES);
    }

    default public void setClothes(ResourceLocation clothes) {
        this.setClothes(clothes.toString());
    }

    default public void setClothes(String clothes) {
        this.setTrackedValue(CLOTHES, clothes);
    }

    default public String getHair() {
        return (String)this.getTrackedValue(HAIR);
    }

    default public void setHair(ResourceLocation hair) {
        this.setHair(hair.toString());
    }

    default public void setHair(String hair) {
        this.setTrackedValue(HAIR, hair);
    }

    default public void setHairDye(float r, float g, float b) {
        this.setTrackedValue(HAIR_COLOR_RED, Float.valueOf(r));
        this.setTrackedValue(HAIR_COLOR_GREEN, Float.valueOf(g));
        this.setTrackedValue(HAIR_COLOR_BLUE, Float.valueOf(b));
    }

    default public void clearHairDye() {
        this.setHairDye(0.0f, 0.0f, 0.0f);
    }

    default public int getHairDye() {
        return FastColor.ARGB32.colorFromFloat((float)1.0f, (float)((Float)this.getTrackedValue(HAIR_COLOR_RED)).floatValue(), (float)((Float)this.getTrackedValue(HAIR_COLOR_GREEN)).floatValue(), (float)((Float)this.getTrackedValue(HAIR_COLOR_BLUE)).floatValue());
    }

    default public void setHairDye(DyeColor color) {
        int components = color.getTextureDiffuseColor();
        int dye = this.getHairDye();
        if (dye > 0) {
            components = FastColor.ARGB32.lerp((float)0.5f, (int)components, (int)dye);
        }
        this.setTrackedValue(HAIR_COLOR_RED, Float.valueOf((float)FastColor.ARGB32.red((int)components) / 255.0f));
        this.setTrackedValue(HAIR_COLOR_GREEN, Float.valueOf((float)FastColor.ARGB32.green((int)components) / 255.0f));
        this.setTrackedValue(HAIR_COLOR_BLUE, Float.valueOf((float)FastColor.ARGB32.blue((int)components) / 255.0f));
    }

    default public AgeState getAgeState() {
        return (AgeState)this.getTrackedValue(AGE_STATE);
    }

    default public VillagerDimensions getVillagerDimensions() {
        return this.getAgeState();
    }

    default public void updateAttributes() {
        AttributeInstance attackAttributeInstance;
        float speed = 1.0f;
        if (this.getTraits().hasTrait(Traits.ATHLETIC)) {
            speed *= 1.1f;
        }
        speed /= 0.9f + this.getGenetics().getGene(Genetics.WIDTH) * 0.2f;
        speed *= 0.9f + this.getGenetics().getGene(Genetics.SIZE) * 0.2f;
        speed *= this.getAgeState().getSpeed();
        AttributeInstance entityAttributeInstance = this.asEntity().getAttribute(Attributes.MOVEMENT_SPEED);
        if (entityAttributeInstance != null) {
            entityAttributeInstance.removeModifier(SPEED_ID);
            AttributeModifier speedModifier = new AttributeModifier(SPEED_ID, (double)(speed - 1.0f), AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
            entityAttributeInstance.addTransientModifier(speedModifier);
        }
        float damageMultiplier = 1.0f;
        if (this.getTraits().hasTrait(Traits.WEAK)) {
            damageMultiplier *= 0.75f;
        }
        if (this.getTraits().hasTrait(Traits.TOUGH)) {
            damageMultiplier *= 1.5f;
        }
        if ((attackAttributeInstance = this.asEntity().getAttribute(Attributes.ATTACK_DAMAGE)) != null) {
            attackAttributeInstance.removeModifier(DAMAGE_ID);
            AttributeModifier damageModifier = new AttributeModifier(DAMAGE_ID, (double)(damageMultiplier - 1.0f), AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
            attackAttributeInstance.addTransientModifier(damageModifier);
        }
    }

    default public boolean setAgeState(AgeState state) {
        AgeState old = this.getAgeState();
        if (state == old) {
            return false;
        }
        this.setTrackedValue(AGE_STATE, state);
        this.asEntity().refreshDimensions();
        this.updateAttributes();
        return old != AgeState.UNASSIGNED;
    }

    default public float getHorizontalScaleFactor() {
        if (this.getGenetics() == null || Config.getInstance().useSquidwardModels) {
            return this.asEntity().isBaby() ? 0.5f : 1.0f;
        }
        return Math.min(0.999f, this.getRawHorizontalScaleFactor());
    }

    default public float getRawHorizontalScaleFactor() {
        return this.getGenetics().getHorizontalScaleFactor() * this.getTraits().getHorizontalScaleFactor() * this.getVillagerDimensions().getWidth() * this.getGenetics().getGender().getHorizontalScaleFactor();
    }

    default public float getVerticalScaleFactor() {
        return Math.min(0.999f, this.getRawVerticalScaleFactor());
    }

    default public float getRawVerticalScaleFactor() {
        if (this.getGenetics() == null || Config.getInstance().useSquidwardModels) {
            return this.asEntity().isBaby() ? 0.5f : 1.0f;
        }
        return this.getGenetics().getVerticalScaleFactor() * this.getTraits().getVerticalScaleFactor() * this.getVillagerDimensions().getHeight() * this.getGenetics().getGender().getScaleFactor();
    }

    @Override
    default public DialogueType getDialogueType(Player receiver) {
        if (!receiver.level().isClientSide) {
            Optional<EntityRelationship> r;
            DialogueType type = DialogueType.fromAge(this.getAgeState());
            if (!receiver.level().isClientSide && (r = EntityRelationship.of((Entity)this.asEntity())).isPresent()) {
                FamilyTreeNode relationship = r.get().getFamilyEntry();
                if (r.get().isMarriedTo(receiver.getUUID())) {
                    return DialogueType.SPOUSE;
                }
                if (r.get().isEngagedWith(receiver.getUUID())) {
                    return DialogueType.ENGAGED;
                }
                if (relationship.isParent(receiver.getUUID())) {
                    return type.toChild();
                }
            }
            this.getVillagerBrain().getMemoriesForPlayer(receiver).setDialogueType(type);
        }
        return this.getVillagerBrain().getMemoriesForPlayer(receiver).getDialogueType();
    }

    default public void initializeSkin(boolean isPlayer) {
        Mob entity;
        this.randomizeClothes();
        this.randomizeHair();
        if (!isPlayer && (entity = this.asEntity()).getRandom().nextFloat() < Config.getInstance().coloredHairChance) {
            int n = entity.getRandom().nextInt(25);
            int o = DyeColor.values().length;
            int p = n % o;
            int q = (n + 1) % o;
            float r = entity.getRandom().nextFloat();
            int fs = Sheep.getColor((DyeColor)DyeColor.byId((int)p));
            int gs = Sheep.getColor((DyeColor)DyeColor.byId((int)q));
            int color = FastColor.ARGB32.lerp((float)r, (int)fs, (int)gs);
            this.setTrackedValue(HAIR_COLOR_RED, Float.valueOf((float)FastColor.ARGB32.red((int)color) / 255.0f));
            this.setTrackedValue(HAIR_COLOR_GREEN, Float.valueOf((float)FastColor.ARGB32.green((int)color) / 255.0f));
            this.setTrackedValue(HAIR_COLOR_BLUE, Float.valueOf((float)FastColor.ARGB32.blue((int)color) / 255.0f));
        }
    }

    default public void randomizeClothes() {
        this.setClothes(ClothingList.getInstance().getPool(this).pickOne());
    }

    default public void randomizeHair() {
        this.setHair(HairList.getInstance().getPool(this.getGenetics().getGender()).pickOne());
    }

    default public void validateClothes() {
        if (!this.asEntity().level().isClientSide()) {
            if (!this.getClothes().startsWith("immersive_library") && !ClothingList.getInstance().clothing.containsKey(this.getClothes())) {
                MCA.LOGGER.info("Villagers clothing {} does not exist!", (Object)this.getClothes());
                this.randomizeClothes();
            }
            if (!this.getHair().startsWith("immersive_library") && !HairList.getInstance().hair.containsKey(this.getHair())) {
                MCA.LOGGER.info("Villagers hair {} does not exist!", (Object)this.getHair());
                this.randomizeHair();
            }
        }
    }

    default public CompoundTag toNbtForConversion() {
        CompoundTag output = new CompoundTag();
        this.getTypeDataManager().save(this.asEntity(), output);
        return output;
    }

    default public void readNbtForConversion(CompoundTag input) {
        this.getTypeDataManager().load(this.asEntity(), input);
    }

    default public void syncFromEditor(CompoundTag nbt) {
        Mob entity = this.asEntity();
        entity.readAdditionalSaveData(nbt);
        if (nbt.contains("CustomName", 8)) {
            String s = nbt.getString("CustomName");
            try {
                entity.setCustomName((Component)Component.Serializer.fromJson((String)s, (HolderLookup.Provider)entity.registryAccess()));
            }
            catch (Exception exception) {
                MCA.LOGGER.warn("Failed to parse entity custom name {}", (Object)s, (Object)exception);
            }
        }
    }

    default public void copyVillagerAttributesFrom(VillagerLike<?> other) {
        this.readNbtForConversion(other.toNbtForConversion());
    }

    default public boolean isHostile() {
        return false;
    }

    default public PlayerModel getPlayerModel() {
        return PlayerModel.VILLAGER;
    }

    public boolean isBurned();

    default public void spawnBurntParticles() {
        RandomSource random = this.asEntity().getRandom();
        if (random.nextInt(4) == 0) {
            double d = random.nextGaussian() * 0.02;
            double e = random.nextGaussian() * 0.02;
            double f = random.nextGaussian() * 0.02;
            this.asEntity().level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.asEntity().getRandomX(1.0), this.asEntity().getRandomY() + 1.0, this.asEntity().getRandomZ(1.0), d, e, f);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        CLOTHES = CParameter.create("Clothes", "");
        HAIR = CParameter.create("Hair", "");
        HAIR_COLOR_RED = CParameter.create("HairColorRed", 0.0f);
        HAIR_COLOR_GREEN = CParameter.create("HairColorGreen", 0.0f);
        HAIR_COLOR_BLUE = CParameter.create("HairColorBlue", 0.0f);
        AGE_STATE = CParameter.create("AgeState", AgeState.UNASSIGNED);
        SPEED_ID = MCA.locate("trait_speed");
        DAMAGE_ID = MCA.locate("trait_damage");
    }

    public static enum PlayerModel {
        VILLAGER,
        PLAYER,
        VANILLA;

        static final PlayerModel[] VALUES;

        static {
            VALUES = PlayerModel.values();
        }
    }
}

