/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai;

import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;

public class ConversationManager {
    private final VillagerEntityMCA entity;
    private final Queue<Message> pendingMessages = new ConcurrentLinkedQueue<Message>();

    public ConversationManager(VillagerEntityMCA entity) {
        this.entity = entity;
    }

    public void addMessage(Entity receiver, MutableComponent message) {
        this.addMessage(new TextMessage(receiver, message));
    }

    public void addMessage(Message message) {
        this.pendingMessages.add(message);
        message.entity = this.entity;
    }

    public Optional<Message> getCurrentMessage() {
        Message message = this.pendingMessages.peek();
        if (message == null) {
            return Optional.empty();
        }
        if (message.stillValid()) {
            return Optional.of(message);
        }
        this.pendingMessages.remove(message);
        return this.getCurrentMessage();
    }

    public static class TextMessage
    extends Message {
        private final MutableComponent text;

        public TextMessage(Entity receiver, MutableComponent text) {
            super(receiver);
            this.text = text;
        }

        @Override
        public void deliver() {
            this.entity.sendChatToAllAround(this.text);
            super.deliver();
        }
    }

    public static abstract class Message {
        public static final int TIME_VALID = 6000;
        public final int validUntil;
        private final Entity receiver;
        VillagerEntityMCA entity;
        private boolean delivered = false;

        private Message(Entity receiver) {
            this.receiver = receiver;
            this.validUntil = receiver.tickCount + 6000;
        }

        public Entity getReceiver() {
            return this.receiver;
        }

        public void deliver() {
            this.delivered = true;
        }

        public boolean stillValid() {
            return !this.delivered && !this.receiver.isRemoved() && this.receiver.tickCount < this.validUntil;
        }
    }

    public static class PhraseText
    extends Message {
        private final String text;

        public PhraseText(Entity receiver, String text) {
            super(receiver);
            this.text = text;
        }

        @Override
        public void deliver() {
            this.entity.sendChatToAllAround(this.text, new Object[0]);
            super.deliver();
        }
    }
}

