/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai;

import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface TaskUtils {
    public static int getSpawnSafeTopLevel(Level world, int x, int y, int z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, Math.min(y, world.getMaxBuildHeight()), z);
        while (world.isEmptyBlock((BlockPos)pos.move(Direction.DOWN)) && pos.getY() > world.getMinBuildHeight()) {
        }
        return pos.getY() + 1;
    }

    public static List<BlockPos> getNearbyBlocks(BlockPos origin, Level world, @Nullable Predicate<BlockState> filter, int xzDist, int yDist) {
        return BlockPos.withinManhattanStream((BlockPos)origin, (int)xzDist, (int)yDist, (int)xzDist).filter(pos -> !origin.equals(pos) && (filter == null || filter.test(world.getBlockState(pos)))).map(BlockPos::immutable).toList();
    }

    @Nullable
    public static BlockPos getNearestPoint(BlockPos origin, List<BlockPos> blocks) {
        return blocks.stream().min(Comparator.comparing(arg_0 -> ((BlockPos)origin).distSqr(arg_0))).orElse(null);
    }
}

