/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;

public class LoseUnimportantJobTask {
    protected static boolean shouldRun(ServerLevel world, Villager entity) {
        return !((VillagerEntityMCA)entity).isProfessionImportant();
    }

    public static BehaviorControl<Villager> create() {
        return BehaviorBuilder.create(context -> context.group((App)context.absent(MemoryModuleType.JOB_SITE)).apply((Applicative)context, jobSite -> (world, entity, time) -> {
            VillagerData villagerData = entity.getVillagerData();
            if (LoseUnimportantJobTask.shouldRun(world, entity) && villagerData.getProfession() != VillagerProfession.NONE && villagerData.getProfession() != VillagerProfession.NITWIT && entity.getVillagerXp() == 0 && villagerData.getLevel() <= 1) {
                entity.setVillagerData(entity.getVillagerData().setProfession(VillagerProfession.NONE));
                entity.refreshBrain(world);
                return true;
            }
            return false;
        }));
    }
}

