/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.goal;

import java.util.EnumSet;
import net.conczin.mca.entity.GrimReaperEntity;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GrimReaperIdleGoal
extends Goal {
    protected final GrimReaperEntity reaper;
    protected final double speedModifier;
    protected final int interval;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;

    public GrimReaperIdleGoal(GrimReaperEntity reaper, double speed) {
        this(reaper, speed, 120);
    }

    public GrimReaperIdleGoal(GrimReaperEntity reaper, double speed, int interval) {
        this.reaper = reaper;
        this.speedModifier = speed;
        this.interval = interval;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.reaper.getRandom().nextInt(this.interval) != 0) {
            return false;
        }
        Vec3 vector3d = this.getPosition();
        if (vector3d == null) {
            return false;
        }
        this.wantedX = vector3d.x;
        this.wantedY = vector3d.y;
        this.wantedZ = vector3d.z;
        return true;
    }

    @Nullable
    protected Vec3 getPosition() {
        if (this.reaper.getTarget() != null) {
            return this.reaper.getTarget().position();
        }
        return AirRandomPos.getPosTowards((PathfinderMob)this.reaper, (int)8, (int)6, (int)-1, (Vec3)Vec3.atBottomCenterOf((Vec3i)this.reaper.blockPosition()), (double)1.0);
    }

    public boolean canContinueToUse() {
        return !this.reaper.getNavigation().isDone();
    }

    public void start() {
        this.reaper.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
    }

    public void stop() {
        this.reaper.getNavigation().stop();
        super.stop();
    }
}

