/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.interaction;

import java.util.Optional;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.OpenGuiRequest;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityCommandHandler<T extends Entity> {
    protected final T entity;
    @Nullable
    protected Player interactingPlayer;

    public EntityCommandHandler(T entity) {
        this.entity = entity;
    }

    public Optional<Player> getInteractingPlayer() {
        return Optional.ofNullable(this.interactingPlayer).filter(player -> player.containerMenu != null);
    }

    public void stopInteracting() {
        Player player;
        if (!this.entity.level().isClientSide && (player = this.interactingPlayer) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.closeContainer();
        }
        this.interactingPlayer = null;
    }

    public InteractionResult interactAt(Player player, Vec3 pos, @NotNull InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Network.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.INTERACT, (Entity)this.entity), serverPlayer);
        }
        this.interactingPlayer = player;
        return InteractionResult.SUCCESS;
    }

    public boolean handle(ServerPlayer player, String command) {
        return false;
    }
}

