/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.mixin.client;

import net.conczin.mca.Config;
import net.conczin.mca.MCAClient;
import net.conczin.mca.client.model.CommonVillagerModel;
import net.conczin.mca.entity.VillagerLike;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer {
    @Shadow
    @Final
    Minecraft minecraft;
    @Shadow
    @Nullable
    PostChain postEffect;
    @Unique
    private Tuple<String, ResourceLocation> mca$currentShader;

    @Shadow
    protected abstract void loadEffect(ResourceLocation var1);

    @Shadow
    public abstract void shutdownEffect();

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void mca$injectTick(CallbackInfo ci) {
        VillagerLike<?> villagerLike;
        if (MCAClient.areShadersAllowed() && this.minecraft.cameraEntity != null && (villagerLike = CommonVillagerModel.getVillager(this.minecraft.cameraEntity)) != null) {
            if (this.postEffect == null) {
                if (this.mca$currentShader != null) {
                    this.loadEffect((ResourceLocation)this.mca$currentShader.getB());
                } else {
                    Config.getInstance().shaderLocationsMap.entrySet().stream().filter(entry -> villagerLike.getTraits().hasTrait((String)entry.getKey())).filter(entry -> MCAClient.areShadersAllowed((String)entry.getKey() + "_shader")).findFirst().ifPresent(entry -> {
                        ResourceLocation shaderId = ResourceLocation.parse((String)((String)entry.getValue()));
                        this.mca$currentShader = new Tuple((Object)((String)entry.getKey()), (Object)shaderId);
                        this.loadEffect(shaderId);
                    });
                }
            } else if (this.mca$currentShader != null && !villagerLike.getTraits().hasTrait((String)this.mca$currentShader.getA())) {
                this.shutdownEffect();
                this.mca$currentShader = null;
            }
        }
    }
}

