/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.network.c2s;

import java.util.HashMap;
import java.util.Map;
import net.conczin.mca.MCA;
import net.conczin.mca.network.HandleablePayload;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.SkinListResponse;
import net.conczin.mca.resources.ClothingList;
import net.conczin.mca.resources.HairList;
import net.conczin.mca.resources.data.skin.Clothing;
import net.conczin.mca.resources.data.skin.Hair;
import net.conczin.mca.server.world.data.CustomClothingManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;

public record SkinListRequest() implements HandleablePayload
{
    public static final CustomPacketPayload.Type<SkinListRequest> TYPE = new CustomPacketPayload.Type(MCA.locate("skin_list_request"));
    public static final StreamCodec<FriendlyByteBuf, SkinListRequest> STREAM_CODEC = StreamCodec.unit((Object)new SkinListRequest());

    private static <T> HashMap<String, T> merge(Map<String, T> a, Map<String, T> b) {
        HashMap<String, T> map = new HashMap<String, T>();
        map.putAll(a);
        map.putAll(b);
        return map;
    }

    @Override
    public void handleServer(ServerPlayer player) {
        Map<String, Clothing> clothing = CustomClothingManager.getClothing().getEntries();
        Map<String, Hair> hair = CustomClothingManager.getHair().getEntries();
        HashMap<String, Clothing> allClothing = SkinListRequest.merge(ClothingList.getInstance().clothing, clothing);
        HashMap<String, Hair> allHair = SkinListRequest.merge(HairList.getInstance().hair, hair);
        Network.sendToPlayer(new SkinListResponse(allClothing, allHair), player);
    }

    public CustomPacketPayload.Type<SkinListRequest> type() {
        return TYPE;
    }
}

