/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.registry;

import java.util.HashMap;
import java.util.Map;
import net.conczin.mca.MCA;
import net.conczin.mca.advancement.criterion.BabyCriterion;
import net.conczin.mca.advancement.criterion.BabyDroppedCriterion;
import net.conczin.mca.advancement.criterion.BabySirbenSmeltedCriterion;
import net.conczin.mca.advancement.criterion.BabySmeltedCriterion;
import net.conczin.mca.advancement.criterion.ChildAgeStateChangeCriterion;
import net.conczin.mca.advancement.criterion.FamilyCriterion;
import net.conczin.mca.advancement.criterion.GenericEventCriterion;
import net.conczin.mca.advancement.criterion.HeartsCriterion;
import net.conczin.mca.advancement.criterion.RankCriterion;
import net.conczin.mca.advancement.criterion.VillagerFateCriterion;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.resources.ResourceLocation;

public interface CriterionMCA {
    public static final Map<ResourceLocation, CriterionTrigger<?>> TRIGGERS = new HashMap();
    public static final BabyCriterion BABY = CriterionMCA.register("baby", new BabyCriterion());
    public static final BabyDroppedCriterion BABY_DROPPED = CriterionMCA.register("baby_dropped", new BabyDroppedCriterion());
    public static final BabySmeltedCriterion BABY_SMELTED = CriterionMCA.register("baby_smelted", new BabySmeltedCriterion());
    public static final BabySirbenSmeltedCriterion BABY_SIRBEN_SMELTED = CriterionMCA.register("baby_sirben_smelted", new BabySirbenSmeltedCriterion());
    public static final HeartsCriterion HEARTS = CriterionMCA.register("hearts", new HeartsCriterion());
    public static final GenericEventCriterion GENERIC_EVENT = CriterionMCA.register("generic_event", new GenericEventCriterion());
    public static final ChildAgeStateChangeCriterion CHILD_AGE_STATE_CHANGE = CriterionMCA.register("child_age_state_change", new ChildAgeStateChangeCriterion());
    public static final FamilyCriterion FAMILY = CriterionMCA.register("family", new FamilyCriterion());
    public static final RankCriterion RANK = CriterionMCA.register("rank", new RankCriterion());
    public static final VillagerFateCriterion FATE = CriterionMCA.register("villager_fate", new VillagerFateCriterion());

    public static <T extends CriterionTrigger<?>> T register(String name, T trigger) {
        TRIGGERS.put(MCA.locate(name), trigger);
        return trigger;
    }

    public static void registerCriteria(MCA.RegisterHelper<CriterionTrigger<?>> helper) {
        TRIGGERS.forEach(helper::register);
    }
}

