/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.resources;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.conczin.mca.MCA;
import net.conczin.mca.resources.Resources;
import net.conczin.mca.resources.data.BuildingType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class BuildingTypes
extends SimpleJsonResourceReloadListener
implements Iterable<BuildingType> {
    protected static final ResourceLocation ID = MCA.locate("building_types");
    private static BuildingTypes INSTANCE = new BuildingTypes();
    private final Map<String, BuildingType> buildingTypes = new HashMap<String, BuildingType>();
    private final Map<String, BuildingType> buildingTypesClient = new HashMap<String, BuildingType>();

    public BuildingTypes() {
        super(Resources.GSON, ID.getPath());
        INSTANCE = this;
    }

    public static BuildingTypes getInstance() {
        return INSTANCE;
    }

    protected void apply(Map<ResourceLocation, JsonElement> prepared, ResourceManager manager, ProfilerFiller profiler) {
        for (Map.Entry<ResourceLocation, JsonElement> pair : prepared.entrySet()) {
            String name = pair.getKey().getPath();
            this.buildingTypes.put(name, new BuildingType(name, pair.getValue().getAsJsonObject()));
        }
        this.setBuildingTypes(this.buildingTypes);
    }

    public Map<String, BuildingType> getServerBuildingTypes() {
        return this.buildingTypes;
    }

    public Map<String, BuildingType> getBuildingTypes() {
        return this.buildingTypesClient;
    }

    public void setBuildingTypes(Map<String, BuildingType> buildingTypes) {
        this.buildingTypesClient.clear();
        this.buildingTypesClient.putAll(buildingTypes);
    }

    public BuildingType getBuildingType(String type) {
        return this.buildingTypesClient.containsKey(type) ? this.buildingTypesClient.get(type) : new BuildingType();
    }

    @Override
    public Iterator<BuildingType> iterator() {
        return this.buildingTypesClient.values().iterator();
    }
}

