/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.resources.data.tasks;

import com.google.gson.JsonObject;
import java.util.Objects;
import net.conczin.mca.resources.data.tasks.Task;
import net.conczin.mca.server.world.data.Village;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;

public class AdvancementTask
extends Task {
    public static final String TYPE = "advancement";
    private final String identifier;

    public AdvancementTask(String identifier) {
        super("advancement_" + identifier);
        this.identifier = identifier;
    }

    public AdvancementTask(JsonObject json) {
        this(GsonHelper.getAsString((JsonObject)json, (String)"id"));
    }

    @Override
    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("type", TYPE);
        json.addProperty("id", this.identifier);
        return json;
    }

    @Override
    public boolean isCompleted(Village village, ServerPlayer player) {
        AdvancementHolder advancement = Objects.requireNonNull(player.getServer()).getAdvancements().get(ResourceLocation.parse((String)this.identifier));
        return advancement != null && player.getAdvancements().getOrStartProgress(advancement).isDone();
    }
}

