/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.resources.data.tasks;

import com.google.gson.JsonObject;
import net.conczin.mca.resources.data.tasks.Task;
import net.conczin.mca.server.world.data.Village;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;

public class BuildingTask
extends Task {
    public static final String TYPE = "building";
    private final String building;

    public BuildingTask(String type) {
        super(type);
        this.building = type;
    }

    public BuildingTask(JsonObject json) {
        this(GsonHelper.getAsString((JsonObject)json, (String)TYPE));
    }

    @Override
    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("type", TYPE);
        json.addProperty(TYPE, this.building);
        return json;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public boolean isCompleted(Village village, ServerPlayer player) {
        return village.getBuildings().values().stream().anyMatch(b -> b.getType().equals(this.building));
    }

    @Override
    public MutableComponent getTranslatable() {
        return Component.translatable((String)"task.build", (Object[])new Object[]{Component.translatable((String)("buildingType." + this.building))});
    }
}

