/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.util.network.datasync;

import net.conczin.mca.util.network.datasync.CParameter;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;

public class CDataParameter<T>
implements CParameter<T, T> {
    private final String id;
    private final T defaultValue;
    private final EntityDataSerializer<T> valueType;
    private final Decoder<T> load;
    private final Encoder<? super T> save;

    protected CDataParameter(String id, EntityDataSerializer<T> valueType, T defaultValue, Decoder<T> load, Encoder<? super T> save) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.valueType = valueType;
        this.load = load;
        this.save = save;
    }

    @Override
    public T getDefault() {
        return this.defaultValue;
    }

    @Override
    public T get(EntityDataAccessor<T> param, SynchedEntityData tracker) {
        return (T)tracker.get(param);
    }

    @Override
    public void set(EntityDataAccessor<T> param, SynchedEntityData tracker, T v) {
        tracker.set(param, v);
    }

    @Override
    public T load(CompoundTag nbt, RegistryAccess registryAccess) {
        return this.load.apply(nbt, this.id, registryAccess);
    }

    @Override
    public void save(CompoundTag nbt, T value, RegistryAccess registryAccess) {
        this.save.accept(nbt, this.id, value, registryAccess);
    }

    @Override
    public EntityDataAccessor<T> createParam(Class<? extends Entity> type) {
        return SynchedEntityData.defineId(type, this.valueType);
    }

    public static interface Decoder<T> {
        public T apply(CompoundTag var1, String var2, RegistryAccess var3);
    }

    public static interface Encoder<T> {
        public void accept(CompoundTag var1, String var2, T var3, RegistryAccess var4);
    }

    public static interface TriConsumer<A, B, C> {
        public void accept(A var1, B var2, C var3);
    }
}

