/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.block;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.conczin.mca.block.BlockEntityTypesMCA;
import net.conczin.mca.entity.Infectable;
import net.conczin.mca.entity.ai.relationship.CompassionateEntity;
import net.conczin.mca.entity.ai.relationship.EntityRelationship;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.registry.BlocksMCA;
import net.conczin.mca.server.world.data.GraveyardManager;
import net.conczin.mca.util.VoxelShapeUtil;
import net.conczin.mca.util.localization.FlowingText;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TombstoneBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final VoxelShape GRAVELLING_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    public static final VoxelShape UPRIGHT_SHAPE = Shapes.or((VoxelShape)Block.box((double)2.0, (double)2.0, (double)7.0, (double)14.0, (double)15.0, (double)9.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)6.0, (double)15.0, (double)2.0, (double)10.0));
    public static final MapCodec<TombstoneBlock> CODEC = TombstoneBlock.simpleCodec(TombstoneBlock::new);
    public static final VoxelShape CROSS_SHAPE = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)28.0, (double)4.0), (VoxelShape)Block.box((double)-1.0, (double)18.0, (double)2.0, (double)17.0, (double)21.0, (double)4.0));
    public static final VoxelShape SLANTED_SHAPE = Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)7.0, (double)14.0);
    public static final VoxelShape WALL_SHAPE = Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0);
    private final Map<Direction, VoxelShape> shapes;
    private final int lineWidth;
    private final int maxNameHeight;
    private final Vec3 nameplateOffset;
    private final boolean requiresSolid;
    private final float rotation;

    public TombstoneBlock(BlockBehaviour.Properties properties) {
        this(properties, 1, 1, Vec3.ZERO, 0.0f, false, UPRIGHT_SHAPE);
    }

    public TombstoneBlock(BlockBehaviour.Properties properties, int lineWidth, int maxNameHeight, Vec3 nameplateOffset, float rotation, boolean requiresSolid, VoxelShape baseShape) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.lineWidth = lineWidth;
        this.maxNameHeight = maxNameHeight;
        this.nameplateOffset = nameplateOffset;
        this.rotation = rotation;
        this.requiresSolid = requiresSolid;
        this.shapes = Arrays.stream(Direction.values()).filter(d -> d.getAxis() != Direction.Axis.Y).collect(Collectors.toMap(Function.identity(), VoxelShapeUtil.rotator(baseShape)));
    }

    static boolean isRemains(ItemStack stack) {
        return stack.getItem() == Items.BONE || stack.getItem() == Items.SKELETON_SKULL;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public int getMaxNameHeight() {
        return this.maxNameHeight;
    }

    public Vec3 getNameplateOffset() {
        return this.nameplateOffset;
    }

    public float getRotation() {
        return this.rotation;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    @Deprecated
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        if (this == BlocksMCA.SLANTED_HEADSTONE) {
            this.shapes.replaceAll((i, v) -> VoxelShapeUtil.rotator(SLANTED_SHAPE).apply((Direction)i));
        }
        return this.shapes.getOrDefault(state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING), Shapes.block());
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        this.updateTombstoneState(world, pos);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        Data.of(world.getBlockEntity(pos)).ifPresent(data -> data.readFromStack(stack));
        this.updateTombstoneState(world, pos);
    }

    private void updateTombstoneState(Level world, BlockPos pos) {
        if (!world.isClientSide) {
            GraveyardManager.get((ServerLevel)world).setTombstoneState(pos, this.hasEntity((BlockGetter)world, pos) ? GraveyardManager.TombstoneState.FILLED : GraveyardManager.TombstoneState.EMPTY);
        }
    }

    @Deprecated
    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        super.onRemove(state, world, pos, newState, moved);
        if (!world.isClientSide && !state.is(newState.getBlock())) {
            this.updateNeighbors(state, world, pos);
            GraveyardManager.get((ServerLevel)world).removeTombstoneState(pos);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return BlockEntityTypesMCA.TOMBSTONE.create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        if (world.isClientSide) {
            return null;
        }
        return (w, pos, s, data) -> ((Data)data).tick();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED}).add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Deprecated
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (direction == Direction.DOWN && !this.canSurvive(state, (LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (this.requiresSolid) {
            pos = pos.below();
            return world.getBlockState(pos).isFaceSturdy((BlockGetter)world, pos, Direction.UP, SupportType.FULL);
        }
        return true;
    }

    @Deprecated
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    private void updateNeighbors(BlockState state, Level world, BlockPos pos) {
        world.updateNeighborsAt(pos, (Block)this);
        world.updateNeighborsAt(pos.relative((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)), (Block)this);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return state.getDirectSignal(world, pos, direction);
    }

    public int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return direction == state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) && this.hasEntity(world, pos) ? 15 : 0;
    }

    protected boolean hasEntity(BlockGetter world, BlockPos pos) {
        return Data.of(world.getBlockEntity(pos)).map(Data::hasEntity).orElse(false);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        Data.of(world.getBlockEntity(pos)).filter(Data::isResurrecting).ifPresent(data -> {
            for (int i = 0; i < random.nextInt(8) + 1; ++i) {
                world.addParticle((ParticleOptions)(random.nextBoolean() ? ParticleTypes.LARGE_SMOKE : ParticleTypes.SMOKE), (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + random.nextFloat()), (double)((float)pos.getZ() + random.nextFloat()), ((double)random.nextFloat() - 0.5) / 10.0, 0.0, ((double)random.nextFloat() - 0.5) / 10.0);
            }
        });
    }

    @Deprecated
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List stacks = super.getDrops(state, builder);
        Optional<Data> data = Data.of((BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY)).filter(Data::hasEntity);
        data.flatMap(Data::getEntityName).ifPresent(name -> stacks.stream().filter(TombstoneBlock::isRemains).forEach(stack -> stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"block.mca.tombstone.remains", (Object[])new Object[]{stack.getHoverName(), name}))));
        data.ifPresent(be -> stacks.stream().filter(s -> s.getItem() == this.asItem()).findFirst().ifPresent(be::writeToStack));
        return stacks;
    }

    public static class Data
    extends BlockEntity {
        private Optional<EntityData> entityData = Optional.empty();
        @Nullable
        private FlowingText computedName;
        private int resurrectionProgress;
        private boolean cure;

        public Data(BlockPos pos, BlockState state) {
            super(BlockEntityTypesMCA.TOMBSTONE, pos, state);
        }

        public static Optional<Data> of(@Nullable BlockEntity be) {
            return Optional.ofNullable(be).filter(p -> p instanceof Data).map(Data.class::cast);
        }

        public boolean isResurrecting() {
            return this.resurrectionProgress > 0;
        }

        public void startResurrecting(boolean cure) {
            this.resurrectionProgress = 1;
            this.cure = cure;
            this.generateLightning();
            this.setChanged();
            this.sync();
        }

        public void tick() {
            if (this.hasEntity() && this.resurrectionProgress > 0) {
                ++this.resurrectionProgress;
                this.setChanged();
                this.sync();
                if (this.resurrectionProgress % 30 == 0) {
                    this.level.playSound(null, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), this.cure ? SoundEvents.BELL_BLOCK : SoundEvents.POLAR_BEAR_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.level.levelEvent(2001, this.worldPosition, Block.getId((BlockState)this.getBlockState()));
                }
                if (this.level.random.nextInt(10) > 5 && this.resurrectionProgress % 20 == 0) {
                    this.generateLightning();
                }
                if (this.resurrectionProgress > 500) {
                    this.resurrectionProgress = 0;
                    this.createEntity(this.level, true).ifPresent(entity -> {
                        this.generateLightning();
                        entity.clearFire();
                        entity.setPortalCooldown();
                        entity.setPos((double)((float)this.worldPosition.getX() + 0.5f), (double)((float)this.worldPosition.getY() + 0.5f), (double)((float)this.worldPosition.getZ() + 0.5f));
                        if (entity instanceof LivingEntity) {
                            LivingEntity l = (LivingEntity)entity;
                            l.setHealth(l.getMaxHealth());
                            l.removeAllEffects();
                            l.fallDistance = 0.0f;
                            l.deathTime = 0;
                        }
                        if (entity instanceof AgeableMob) {
                            AgeableMob mob = (AgeableMob)entity;
                            mob.setAge(mob.getAge());
                        }
                        boolean alreadySpawned = false;
                        if (this.cure && entity instanceof ZombieVillager) {
                            ZombieVillager zombie = (ZombieVillager)entity;
                            entity = zombie.convertTo(EntityType.VILLAGER, true);
                            alreadySpawned = true;
                        }
                        if (entity instanceof CompassionateEntity) {
                            CompassionateEntity compassionateEntity = (CompassionateEntity)entity;
                            compassionateEntity.getRelationships().getFamilyEntry().setDeceased(false);
                        }
                        if (entity instanceof Infectable) {
                            Infectable infectable = (Infectable)entity;
                            infectable.setInfectionProgress(this.cure ? 0.0f : Math.max(Mth.lerp((float)this.level.random.nextFloat(), (float)0.2f, (float)0.6f), infectable.getInfectionProgress()));
                        }
                        if (!alreadySpawned) {
                            this.level.addFreshEntity(entity);
                        }
                    });
                }
            }
        }

        private void generateLightning() {
            this.level.setSkyFlashTime(10);
            LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level);
            bolt.setVisualOnly(true);
            bolt.absMoveTo((double)((float)this.worldPosition.getX() + 0.5f), (double)this.worldPosition.getY(), (double)((float)this.worldPosition.getZ() + 0.5f));
            this.level.addFreshEntity((Entity)bolt);
        }

        public void setEntity(@Nullable Entity entity) {
            this.entityData = Optional.ofNullable(entity).map(e -> new EntityData(this.writeEntityToNbt((Entity)e), e.getName().getString(), EntityRelationship.of(e).map(EntityRelationship::getGender).orElse(Gender.MALE)));
            this.computedName = null;
            this.setChanged();
            if (this.hasLevel()) {
                this.level.playSound(null, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), SoundEvents.BELL_BLOCK, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.level.levelEvent(2001, this.worldPosition, Block.getId((BlockState)this.getBlockState()));
                this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.worldPosition, GameEvent.Context.of((BlockState)this.getBlockState()));
                ((TombstoneBlock)this.getBlockState().getBlock()).updateNeighbors(this.getBlockState(), this.level, this.worldPosition);
                if (!this.level.isClientSide) {
                    GraveyardManager.get((ServerLevel)this.level).setTombstoneState(this.worldPosition, this.hasEntity() ? GraveyardManager.TombstoneState.FILLED : GraveyardManager.TombstoneState.EMPTY);
                    this.sync();
                }
            }
        }

        public boolean hasEntity() {
            return this.entityData.isPresent();
        }

        public Gender getGender() {
            return this.entityData.map(e -> e.gender).orElse(Gender.MALE);
        }

        public Optional<String> getEntityName() {
            return this.entityData.map(e -> e.name);
        }

        public FlowingText getOrCreateEntityName(Function<Component, FlowingText> factory) {
            if (this.computedName == null) {
                this.computedName = factory.apply((Component)Component.literal((String)this.getEntityName().orElse("")));
            }
            return this.computedName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Optional<Entity> createEntity(Level world, boolean remove) {
            try {
                Optional<Entity> optional = this.entityData.flatMap(data -> EntityType.create((CompoundTag)data.nbt, (Level)world));
                return optional;
            }
            finally {
                if (remove) {
                    this.setEntity(null);
                }
            }
        }

        private CompoundTag writeEntityToNbt(Entity entity) {
            CompoundTag nbt = new CompoundTag();
            entity.saveWithoutId(nbt);
            nbt.putString("id", EntityType.getKey((EntityType)entity.getType()).toString());
            return nbt;
        }

        protected void sync() {
            this.setChanged();
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }

        protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            this.entityData = tag.contains("EntityData", 10) ? Optional.of(new EntityData(tag)) : Optional.empty();
            this.resurrectionProgress = tag.getInt("ResurrectionProgress");
            this.cure = tag.getBoolean("Cure");
        }

        public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
            this.entityData.ifPresent(data -> data.writeNbt(nbt));
            nbt.putInt("ResurrectionProgress", this.resurrectionProgress);
            nbt.putBoolean("Cure", this.cure);
        }

        public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
            CompoundTag tag = new CompoundTag();
            this.saveAdditional(tag, registries);
            return tag;
        }

        public ClientboundBlockEntityDataPacket getUpdatePacket() {
            return ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::getUpdateTag);
        }

        public void readFromStack(ItemStack stack) {
            this.entityData = Optional.ofNullable(stack).filter(s -> s.has(DataComponents.ENTITY_DATA)).map(s -> ((CustomData)s.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag()).map(EntityData::new);
        }

        public void writeToStack(ItemStack stack) {
            this.entityData.ifPresent(data -> data.writeNbt(((CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag()));
        }

        static final class EntityData {
            private final CompoundTag nbt;
            private final String name;
            private final Gender gender;

            public EntityData(CompoundTag nbt, String name, Gender gender) {
                this.nbt = nbt;
                this.name = name;
                this.gender = gender;
            }

            EntityData(CompoundTag nbt) {
                this(nbt.getCompound("EntityData"), nbt.getString("EntityName"), Gender.byId(nbt.getInt("EntityGender")));
            }

            void writeNbt(CompoundTag nbt) {
                nbt.put("EntityData", (Tag)this.nbt);
                nbt.putString("EntityName", this.name);
                nbt.putInt("EntityGender", this.gender.ordinal());
            }
        }
    }
}

