/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.book.pages;

import java.util.List;
import net.conczin.mca.client.book.pages.ListPage;
import net.conczin.mca.client.gui.ExtendedBookScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class CenteredListPage
extends ListPage {
    public static final int ENTRIES_PER_PAGE = 11;
    final Component title;

    public CenteredListPage(Component title, List<Component> text) {
        super(text);
        this.title = title;
    }

    public CenteredListPage(String title, List<Component> text) {
        this((Component)Component.translatable((String)title).withStyle(ChatFormatting.BLACK).withStyle(ChatFormatting.BOLD), text);
    }

    private static void drawCenteredText(ExtendedBookScreen screen, GuiGraphics context, Font textRenderer, Component text, int centerX, int y, int color) {
        FormattedCharSequence orderedText = text.getVisualOrderText();
        context.drawString(textRenderer, orderedText, centerX - textRenderer.width(orderedText) / 2, y, color, screen.getBook().hasTextShadow());
    }

    @Override
    int getEntriesPerPage() {
        return 11;
    }

    @Override
    public void render(ExtendedBookScreen screen, GuiGraphics context, int mouseX, int mouseY, float delta) {
        CenteredListPage.drawCenteredText(screen, context, screen.getTextRenderer(), this.title, screen.width / 2, 35, -1);
        int y = 48;
        for (int i = this.page * 11; i < Math.min(this.text.size(), (this.page + 1) * 11); ++i) {
            CenteredListPage.drawCenteredText(screen, context, screen.getTextRenderer(), (Component)this.text.get(i), screen.width / 2 - 4, y, -1);
            y += 10;
        }
    }
}

