/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.conczin.mca.MCA;
import net.conczin.mca.client.gui.InteractScreen;
import net.conczin.mca.client.gui.MCAScreens;
import net.conczin.mca.client.resources.Icon;
import net.conczin.mca.entity.ai.relationship.RelationshipState;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.c2s.GetFamilyTreeRequest;
import net.conczin.mca.server.world.data.FamilyTreeNode;
import net.conczin.mca.util.compat.ButtonWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class FamilyTreeScreen
extends Screen {
    private static final int HORIZONTAL_SPACING = 20;
    private static final int VERTICAL_SPACING = 60;
    private static final int SPOUSE_HORIZONTAL_SPACING = 50;
    private final Map<UUID, FamilyTreeNode> family = new HashMap<UUID, FamilyTreeNode>();
    private final TreeNode emptyNode;
    private final Screen parent;
    private UUID focusedEntityId;
    private TreeNode tree = this.emptyNode = new TreeNode();
    @Nullable
    private TreeNode focused;
    private double scrollX;
    private double scrollY;

    public FamilyTreeScreen(UUID entityId) {
        super((Component)Component.translatable((String)"gui.family_tree.title"));
        this.focusedEntityId = entityId;
        this.parent = Minecraft.getInstance().screen;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void setFamilyData(UUID uuid, Map<UUID, FamilyTreeNode> family) {
        this.focusedEntityId = uuid;
        this.family.putAll(family);
        this.rebuildTree();
    }

    private boolean focusEntity(UUID id) {
        this.focusedEntityId = id;
        Network.sendToServer(new GetFamilyTreeRequest(id));
        return false;
    }

    public void init() {
        this.focusEntity(this.focusedEntityId);
        this.addRenderableWidget((GuiEventListener)new ButtonWidget(this.width / 2 - 100, this.height - 25, 200, 20, (Component)Component.translatable((String)"gui.done"), sender -> this.onClose()));
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0) {
            this.scrollX += deltaX;
            this.scrollY += deltaY;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.focused != null) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            if (this.focusEntity(this.focused.id)) {
                this.rebuildTree();
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        context.fill(0, 30, this.width, this.height - 30, 0x66000000);
        this.focused = null;
        Window window = Minecraft.getInstance().getWindow();
        double f = window.getGuiScale();
        int windowHeight = (int)Math.round((double)window.getGuiScaledHeight() * f);
        int x = 0;
        int y = (int)(30.0 * f);
        int w = (int)((double)this.width * f);
        int h = (int)((double)(this.height - 60) * f);
        GL11.glScissor((int)x, (int)(windowHeight - h - y), (int)w, (int)h);
        GL11.glEnable((int)3089);
        PoseStack matrices = context.pose();
        matrices.pushPose();
        int xx = (int)(this.scrollX + (double)this.width / 2.0);
        int yy = (int)(this.scrollY + (double)this.height / 2.0);
        matrices.translate((float)xx, (float)yy, 0.0f);
        this.tree.render(context, mouseX - xx, mouseY - yy);
        matrices.popPose();
        GL11.glDisable((int)3089);
        FamilyTreeNode selected = this.family.get(this.focusedEntityId);
        Component label = selected == null ? this.title : Component.literal((String)selected.getName()).append("'s ").append(this.title);
        context.drawCenteredString(this.font, label, this.width / 2, 10, 0xFFFFFF);
    }

    private void rebuildTree() {
        this.scrollX = 14.0;
        this.scrollY = -69.0;
        FamilyTreeNode focusedNode = this.family.get(this.focusedEntityId);
        this.focused = null;
        this.tree = this.emptyNode;
        if (focusedNode != null) {
            this.tree = this.insertParents(new TreeNode(focusedNode, true), focusedNode, 2);
        }
    }

    private TreeNode insertParents(TreeNode root, FamilyTreeNode focusedNode, int levels) {
        @Nullable FamilyTreeNode father = this.family.get(focusedNode.father());
        @Nullable FamilyTreeNode mother = this.family.get(focusedNode.mother());
        @Nullable FamilyTreeNode newRoot = father != null ? father : mother;
        TreeNode fNode = newRoot == null ? new TreeNode() : new TreeNode(newRoot, false);
        fNode.children.add(root);
        @Nullable FamilyTreeNode spouse = newRoot == father ? mother : father;
        TreeNode treeNode = fNode.spouse = spouse == null ? new TreeNode() : new TreeNode(spouse, false);
        if (newRoot != null && levels > 0) {
            return this.insertParents(fNode, newRoot, levels - 1);
        }
        return fNode;
    }

    private final class TreeNode {
        final UUID id;
        final boolean deceased;
        private final List<Component> label = new ArrayList<Component>();
        private final List<TreeNode> children = new ArrayList<TreeNode>();
        private final RelationshipState relationship;
        private final String defaultNodeName = "???";
        TreeNode spouse;
        private boolean widthComputed;
        private int width;
        private int labelWidth;
        private Bounds bounds;

        private TreeNode() {
            this.id = null;
            this.deceased = false;
            this.relationship = RelationshipState.SINGLE;
            this.label.add((Component)Component.literal((String)"???"));
        }

        public TreeNode(FamilyTreeNode node, boolean recurse) {
            this(node, new HashSet<UUID>(), recurse);
        }

        public TreeNode(FamilyTreeNode node, Set<UUID> parsed, boolean recurse) {
            this.id = node.id();
            this.deceased = node.isDeceased();
            this.relationship = node.getRelationshipState();
            MutableComponent text = Component.literal((String)(MCA.isBlankString(node.getName()) ? "???" : node.getName()));
            this.label.add((Component)text.setStyle(text.getStyle().withColor(node.gender().getColor())));
            this.label.add((Component)node.getProfessionText().withStyle(ChatFormatting.GRAY));
            FamilyTreeNode father = FamilyTreeScreen.this.family.get(node.father());
            FamilyTreeNode mother = FamilyTreeScreen.this.family.get(node.mother());
            if ((father == null || father.isDeceased()) && (mother == null || mother.isDeceased())) {
                this.label.add((Component)Component.translatable((String)"gui.family_tree.label.orphan").withStyle(ChatFormatting.GRAY));
            }
            if (node.getRelationshipState() != RelationshipState.SINGLE) {
                this.label.add((Component)Component.translatable((String)("marriage." + node.getRelationshipState().base().getIcon())));
            }
            if (recurse) {
                node.children().forEach(child -> {
                    FamilyTreeNode e = FamilyTreeScreen.this.family.get(child);
                    if (e != null) {
                        this.children.add(new TreeNode(e, parsed, parsed.add((UUID)child)));
                    }
                });
                FamilyTreeNode spouse = FamilyTreeScreen.this.family.get(node.partner());
                if (spouse != null) {
                    this.spouse = new TreeNode(spouse, parsed, false);
                } else if (!this.children.isEmpty()) {
                    this.spouse = new TreeNode();
                }
            }
        }

        public void render(GuiGraphics context, int mouseX, int mouseY) {
            boolean isFocused;
            PoseStack matrices = context.pose();
            Bounds bounds = this.getBounds();
            boolean bl = isFocused = this.id != null && bounds.contains(mouseX, mouseY);
            if (isFocused) {
                FamilyTreeScreen.this.focused = this;
            }
            int childrenStartX = -this.getWidth() / 2;
            for (TreeNode node : this.children) {
                int x = (childrenStartX += (node.getWidth() + 20) / 2) + 10;
                int y = 60;
                this.drawHook(context, x, y);
                matrices.pushPose();
                matrices.translate((float)x, (float)y, 0.0f);
                node.render(context, mouseX - x, mouseY - y);
                matrices.popPose();
                childrenStartX += (node.getWidth() + 20) / 2;
            }
            matrices.pushPose();
            matrices.translate(0.0f, 0.0f, 400.0f);
            int fillColor = isFocused ? -267386816 : -267386864;
            int borderColor = isFocused ? -14155649 : 0x505000FF;
            context.fill(bounds.left, bounds.top + 1, bounds.left + 1, bounds.bottom - 1, fillColor);
            context.fill(bounds.right - 1, bounds.top + 1, bounds.right, bounds.bottom - 1, fillColor);
            context.fill(bounds.left + 1, bounds.top, bounds.right - 1, bounds.bottom, fillColor);
            context.fill(bounds.left + 1, bounds.top + 1, bounds.left + 2, bounds.bottom - 1, borderColor);
            context.fill(bounds.right - 2, bounds.top + 1, bounds.right - 1, bounds.bottom - 1, borderColor);
            context.fill(bounds.left + 2, bounds.top + 1, bounds.right - 2, bounds.top + 2, borderColor);
            context.fill(bounds.left + 2, bounds.bottom - 2, bounds.right - 2, bounds.bottom - 1, borderColor);
            MultiBufferSource.BufferSource immediate = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(1536));
            int l = bounds.top + 5;
            int k = bounds.left + 6;
            if (this.deceased) {
                k += 20;
            }
            Matrix4f matrix4f = matrices.last().pose();
            Font r = Minecraft.getInstance().font;
            for (int s = 0; s < this.label.size(); ++s) {
                Component line = this.label.get(s);
                if (line != null) {
                    r.drawInBatch(line, (float)k, (float)l, -1, true, matrix4f, (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                }
                if (s == 0) {
                    l += 2;
                }
                l += 10;
            }
            immediate.endBatch();
            matrices.popPose();
            if (this.deceased) {
                Icon icon = MCAScreens.getInstance().getIcon("deceased");
                context.blit(InteractScreen.ICON_TEXTURES, bounds.left + 6, bounds.top + 6, 0, (float)icon.u(), (float)icon.v(), 16, 16, 256, 256);
                if (isFocused && mouseX <= bounds.left + 20) {
                    matrices.pushPose();
                    matrices.translate(0.0f, 0.0f, 20.0f);
                    context.renderTooltip(FamilyTreeScreen.this.font, (Component)Component.translatable((String)"gui.family_tree.label.deceased"), mouseX, mouseY);
                    matrices.popPose();
                }
            }
            if (this.spouse != null) {
                int x = bounds.left - 50;
                int y = bounds.top + bounds.bottom / 2;
                context.hLine(x, bounds.left - 1, y, -1);
                if (this.relationship == RelationshipState.MARRIED_TO_PLAYER || this.relationship == RelationshipState.MARRIED_TO_VILLAGER || this.relationship == RelationshipState.ENGAGED || this.relationship == RelationshipState.PROMISED || this.relationship == RelationshipState.WIDOW) {
                    Icon icon = MCAScreens.getInstance().getIcon(this.relationship.getIcon());
                    context.blit(InteractScreen.ICON_TEXTURES, bounds.left - 25 - 8, y - 8, 0, (float)icon.u(), (float)icon.v(), 16, 16, 256, 256);
                }
                int n = this.spouse.label.size();
                Objects.requireNonNull(FamilyTreeScreen.this.font);
                matrices.pushPose();
                matrices.translate((float)(x -= this.spouse.getWidth() / 2 - 6), (float)(y -= n * 9 / 2), 0.0f);
                this.spouse.render(context, mouseX - x, mouseY - y);
                matrices.popPose();
            }
        }

        private void drawHook(GuiGraphics context, int endX, int endY) {
            int midY = endY / 2;
            context.vLine(0, 0, midY, -1);
            context.hLine(0, endX, midY, -1);
            context.vLine(endX, midY, endY, -1);
        }

        public int getWidth() {
            if (!this.widthComputed) {
                this.widthComputed = true;
                this.labelWidth = this.label.stream().mapToInt(arg_0 -> ((Font)FamilyTreeScreen.this.font).width(arg_0)).max().orElse(0);
                if (this.deceased) {
                    this.labelWidth += 20;
                }
                this.width = Math.max(this.labelWidth + 10, this.children.stream().mapToInt(TreeNode::getWidth).sum()) + 10;
                if (this.spouse != null) {
                    this.width += this.spouse.getWidth() + 50;
                }
            }
            return this.width;
        }

        public Bounds getBounds() {
            if (this.bounds == null) {
                this.getWidth();
                int padding = 4;
                int n = -this.labelWidth / 2 - padding;
                int n2 = this.labelWidth / 2 + padding * 2;
                int n3 = -padding;
                Objects.requireNonNull(FamilyTreeScreen.this.font);
                this.bounds = new Bounds(n, n2, n3, 9 * this.label.size() + padding * 2);
            }
            return this.bounds;
        }
    }

    record Bounds(int left, int right, int top, int bottom) {
        public Bounds add(int x, int y) {
            return new Bounds(this.left + x, this.right + x, this.top + y, this.bottom + y);
        }

        public boolean contains(int mouseX, int mouseY) {
            return mouseX >= this.left && mouseY >= this.top && mouseX <= this.right && mouseY <= this.bottom;
        }
    }
}

