/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.gui.immersive_library;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.LinkedList;
import java.util.Queue;
import net.conczin.mca.client.gui.SkinLibraryScreen;
import net.conczin.mca.client.gui.immersive_library.types.LiteContent;
import net.conczin.mca.client.resources.SkinMeta;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.resources.data.skin.Clothing;
import net.conczin.mca.resources.data.skin.Hair;
import net.conczin.mca.resources.data.skin.SkinListEntry;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.Mth;

public final class Workspace {
    private static final int MAX_HISTORY = 50;
    public final NativeImage currentImage;
    public final DynamicTexture backendTexture;
    public SkinLibraryScreen.SkinType skinType;
    public int contentid = -1;
    public int temperature;
    public double chance = 1.0;
    public String title = "Unnamed Asset";
    public String profession;
    public Gender gender = Gender.NEUTRAL;
    public int fillToolThreshold = 32;
    public LinkedList<NativeImage> history = new LinkedList();
    private boolean dirty;
    private boolean dirtySinceSnapshot;

    public Workspace(NativeImage image) {
        this.currentImage = image;
        this.backendTexture = new DynamicTexture(this.currentImage);
        this.dirty = true;
    }

    public Workspace(NativeImage image, SkinMeta meta, LiteContent content) {
        this(image);
        this.contentid = content.contentid();
        this.title = content.title();
        this.skinType = content.hasTag("clothing") ? SkinLibraryScreen.SkinType.CLOTHING : SkinLibraryScreen.SkinType.HAIR;
        this.chance = meta.getChance();
        this.gender = meta.getGender();
        this.profession = meta.getProfession();
        this.temperature = meta.getTemperature();
    }

    public SkinListEntry toListEntry() {
        if (this.skinType == SkinLibraryScreen.SkinType.CLOTHING) {
            return new Clothing("immersive_library:" + this.contentid, this.profession, this.temperature, false, this.gender);
        }
        return new Hair("immersive_library:" + this.contentid);
    }

    private void fillDeleteFunc(FillTodo entry, Queue<FillTodo> todo, int x, int y) {
        if (x < 0 || y < 0 || x >= 64 || y >= 64) {
            return;
        }
        FillTodo nextEntry = new FillTodo(x, y, this.currentImage.getRedOrLuminance(x, y), this.currentImage.getGreenOrLuminance(x, y), this.currentImage.getBlueOrLuminance(x, y), this.currentImage.getLuminanceOrAlpha(x, y));
        if (Math.abs(nextEntry.red - entry.red) > this.fillToolThreshold) {
            return;
        }
        if (Math.abs(nextEntry.green - entry.green) > this.fillToolThreshold) {
            return;
        }
        if (Math.abs(nextEntry.blue - entry.blue) > this.fillToolThreshold) {
            return;
        }
        if (Math.abs(nextEntry.alpha - entry.alpha) > this.fillToolThreshold) {
            return;
        }
        todo.add(nextEntry);
    }

    public void removeSaturation() {
        this.saveSnapshot(true);
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 64; ++y) {
                int r = this.currentImage.getRedOrLuminance(x, y) & 0xFF;
                int g = this.currentImage.getGreenOrLuminance(x, y) & 0xFF;
                int b = this.currentImage.getBlueOrLuminance(x, y) & 0xFF;
                int a = this.currentImage.getLuminanceOrAlpha(x, y) & 0xFF;
                int l = Mth.clamp((int)((int)(0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b)), (int)0, (int)255);
                this.currentImage.setPixelRGBA(x, y, a << 24 | l << 16 | l << 8 | l);
            }
        }
        this.dirty = true;
    }

    public void addBrightness(int i) {
        this.saveSnapshot(true);
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 64; ++y) {
                int r = Mth.clamp((int)((this.currentImage.getRedOrLuminance(x, y) & 0xFF) + i), (int)0, (int)255);
                int g = Mth.clamp((int)((this.currentImage.getGreenOrLuminance(x, y) & 0xFF) + i), (int)0, (int)255);
                int b = Mth.clamp((int)((this.currentImage.getBlueOrLuminance(x, y) & 0xFF) + i), (int)0, (int)255);
                int a = this.currentImage.getLuminanceOrAlpha(x, y) & 0xFF;
                this.currentImage.setPixelRGBA(x, y, a << 24 | r << 16 | g << 8 | b);
            }
        }
        this.dirty = true;
    }

    public void addContrast(float c) {
        int y;
        int x;
        this.saveSnapshot(true);
        int average = 0;
        int samples = 0;
        for (x = 0; x < 64; ++x) {
            for (y = 0; y < 64; ++y) {
                int a = this.currentImage.getLuminanceOrAlpha(x, y) & 0xFF;
                if (a <= 0) continue;
                average += this.currentImage.getRedOrLuminance(x, y) & 0xFF;
                average += this.currentImage.getBlueOrLuminance(x, y) & 0xFF;
                average += this.currentImage.getGreenOrLuminance(x, y) & 0xFF;
                samples += 3;
            }
        }
        average /= samples;
        for (x = 0; x < 64; ++x) {
            for (y = 0; y < 64; ++y) {
                int r = Mth.clamp((int)((int)((float)((this.currentImage.getRedOrLuminance(x, y) & 0xFF) - average) * (1.0f + c) + (float)average)), (int)0, (int)255);
                int g = Mth.clamp((int)((int)((float)((this.currentImage.getGreenOrLuminance(x, y) & 0xFF) - average) * (1.0f + c) + (float)average)), (int)0, (int)255);
                int b = Mth.clamp((int)((int)((float)((this.currentImage.getBlueOrLuminance(x, y) & 0xFF) - average) * (1.0f + c) + (float)average)), (int)0, (int)255);
                int a = this.currentImage.getLuminanceOrAlpha(x, y) & 0xFF;
                this.currentImage.setPixelRGBA(x, y, a << 24 | r << 16 | g << 8 | b);
            }
        }
        this.dirty = true;
    }

    public void fillDelete(int x, int y) {
        if (x < 0 || y < 0 || x >= 64 || y >= 64) {
            return;
        }
        this.saveSnapshot(true);
        LinkedList<FillTodo> todo = new LinkedList<FillTodo>();
        todo.add(new FillTodo(x, y, this.currentImage.getRedOrLuminance(x, y), this.currentImage.getGreenOrLuminance(x, y), this.currentImage.getBlueOrLuminance(x, y), this.currentImage.getLuminanceOrAlpha(x, y)));
        while (!todo.isEmpty()) {
            FillTodo entry = (FillTodo)todo.poll();
            if (this.currentImage.getLuminanceOrAlpha(entry.x, entry.y) == 0) continue;
            this.currentImage.setPixelRGBA(entry.x, entry.y, 0);
            this.dirty = true;
            for (int ox = -1; ox <= 1; ++ox) {
                for (int oy = -1; oy <= 1; ++oy) {
                    if (ox == 0 && oy == 0) continue;
                    this.fillDeleteFunc(entry, todo, entry.x + ox, entry.y + oy);
                }
            }
        }
    }

    public boolean validPixel(int x, int y) {
        return x >= 0 && x < 64 && y >= 0 && y < 64;
    }

    public void saveSnapshot(boolean always) {
        if (always || this.dirtySinceSnapshot) {
            this.dirtySinceSnapshot = false;
            while (this.history.size() > 50) {
                this.history.removeFirst().close();
            }
            NativeImage image = new NativeImage(64, 64, false);
            image.copyFrom(this.currentImage);
            this.history.add(image);
        }
    }

    public void undo() {
        if (this.history.size() > 0) {
            NativeImage image = this.history.removeLast();
            this.currentImage.copyFrom(image);
            image.close();
            this.dirty = true;
            this.dirtySinceSnapshot = false;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        if (dirty) {
            this.dirtySinceSnapshot = true;
        }
    }

    private record FillTodo(int x, int y, int red, int green, int blue, int alpha) {
    }
}

