/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import net.conczin.mca.MCA;
import net.conczin.mca.client.gui.widget.WidgetUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ColorPickerWidget
extends AbstractWidget {
    public static final ResourceLocation MCA_GUI_ICONS_TEXTURE = MCA.locate("textures/gui.png");
    private final DualConsumer<Double, Double> consumer;
    private final ResourceLocation texture;
    double valueX;
    double valueY;

    public ColorPickerWidget(int x, int y, int width, int height, double valueX, double valueY, ResourceLocation texture, DualConsumer<Double, Double> consumer) {
        super(x, y, width, height, (Component)Component.literal((String)""));
        this.consumer = consumer;
        this.texture = texture;
        this.valueX = valueX;
        this.valueY = valueY;
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        context.blit(this.texture, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        WidgetUtils.drawRectangle(context, this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -1426063361);
        context.blit(MCA_GUI_ICONS_TEXTURE, (int)((double)this.getX() + this.valueX * (double)this.width) - 8, (int)((double)this.getY() + this.valueY * (double)this.height) - 8, 240.0f, 0.0f, 16, 16, 256, 256);
        WidgetUtils.drawRectangle(context, this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -1426063361);
    }

    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.update(mouseX, mouseY);
        super.onDrag(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isInArea(mouseX, mouseY)) {
            this.update(mouseX, mouseY);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private boolean isInArea(double mouseX, double mouseY) {
        return mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.height);
    }

    void update(double mouseX, double mouseY) {
        this.valueX = Mth.clamp((double)((mouseX - (double)this.getX()) / (double)this.width), (double)0.0, (double)1.0);
        this.valueY = Mth.clamp((double)((mouseY - (double)this.getY()) / (double)this.height), (double)0.0, (double)1.0);
        this.consumer.apply(this.valueX, this.valueY);
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
        this.defaultButtonNarrationText(builder);
    }

    public double getValueX() {
        return this.valueX;
    }

    public void setValueX(double valueX) {
        this.valueX = valueX;
    }

    public double getValueY() {
        return this.valueY;
    }

    public void setValueY(double valueY) {
        this.valueY = valueY;
    }

    @FunctionalInterface
    public static interface DualConsumer<A, B> {
        public void apply(A var1, B var2);
    }
}

