/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.model;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.util.Mth;

public interface ModelTransformSet {
    public Transformer get(String var1);

    default public ModelTransformSet interpolate(ModelTransformSet to, float delta) {
        if (delta <= 0.0f) {
            return this;
        }
        if (delta >= 1.0f) {
            return to;
        }
        Transformer[] components = new Transformer[2];
        Transformer combined = (part, op, scale) -> {
            components[0].applyTo(part, Op.LERP, delta);
            components[1].applyTo(part, Op.LERP, 1.0f - delta);
        };
        return key -> {
            components[0] = (Transformer)Preconditions.checkNotNull((Object)this.get(key), (Object)("Cannot interpolate because the source set was missing key `" + key + "`"));
            components[1] = (Transformer)Preconditions.checkNotNull((Object)to.get(key), (Object)("Cannot interpolate because the target set was missing key `" + key + "`"));
            return combined;
        };
    }

    public static interface Transformer {
        default public void applyTo(ModelPart part) {
            this.applyTo(part, Op.SET, 1.0f);
        }

        public void applyTo(ModelPart var1, Op var2, float var3);
    }

    public static interface Op {
        public static final Op KEEP = (delta, a, b) -> a;
        public static final Op SET = (delta, a, b) -> b;
        public static final Op ADD = (delta, a, b) -> a + b;
        public static final Op LERP = Mth::lerp;

        public float apply(float var1, float var2, float var3);
    }

    public static class Builder {
        private static final float TO_RADIANS = (float)Math.PI / 180;
        private final Map<String, Transformer> transforms = new HashMap<String, Transformer>();

        public static PartPose createTransform(float x, float y, float z, float pitch, float yaw, float roll) {
            return PartPose.offsetAndRotation((float)x, (float)y, (float)z, (float)(pitch * ((float)Math.PI / 180)), (float)(yaw * ((float)Math.PI / 180)), (float)(roll * ((float)Math.PI / 180)));
        }

        public Builder with(String key, float x, float y, float z, float pitch, float yaw, float roll) {
            return this.with(key, x, y, z, pitch, yaw, roll, Op.SET, Op.SET);
        }

        public Builder with(String key, float x, float y, float z, float pitch, float yaw, float roll, Op pivot) {
            return this.with(key, x, y, z, pitch, yaw, roll, pivot, Op.SET);
        }

        public Builder rotate(String key, float pitch, float yaw, float roll) {
            return this.rotate(key, pitch, yaw, roll, Op.SET);
        }

        public Builder rotate(String key, float pitch, float yaw, float roll, Op op) {
            return this.with(key, 0.0f, 0.0f, 0.0f, pitch, yaw, roll, Op.KEEP, op);
        }

        public Builder with(String key, float x, float y, float z, float pitch, float yaw, float roll, Op pivot, Op rotate) {
            PartPose transform = Builder.createTransform(x, y, z, pitch, yaw, roll);
            this.transforms.put(key, (part, op, delta) -> {
                part.x = op.apply(delta, part.x, pivot.apply(delta, part.x, transform.x));
                part.y = op.apply(delta, part.y, pivot.apply(delta, part.y, transform.y));
                part.z = op.apply(delta, part.z, pivot.apply(delta, part.z, transform.z));
                part.xRot = op.apply(delta, part.xRot, rotate.apply(delta, part.xRot, transform.xRot));
                part.yRot = op.apply(delta, part.yRot, rotate.apply(delta, part.yRot, transform.yRot));
                part.zRot = op.apply(delta, part.zRot, rotate.apply(delta, part.zRot, transform.zRot));
            });
            return this;
        }

        public ModelTransformSet build() {
            return new HashMap<String, Transformer>(this.transforms)::get;
        }
    }
}

