/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.conczin.mca.client.model.CommonVillagerModel;
import net.conczin.mca.client.model.PlayerEntityExtendedModel;
import net.conczin.mca.entity.ai.relationship.AgeState;
import net.conczin.mca.entity.ai.relationship.VillagerDimensions;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.LivingEntity;

public class PlayerArmorExtendedModel<T extends LivingEntity>
extends HumanoidModel<T>
implements CommonVillagerModel<T> {
    public final ModelPart breasts;
    final VillagerDimensions.Mutable dimensions = new VillagerDimensions.Mutable(AgeState.ADULT);
    float breastSize;

    public PlayerArmorExtendedModel(ModelPart root) {
        super(root);
        this.breasts = root.getChild("breasts");
    }

    public void copyPropertiesTo(HumanoidModel<T> target) {
        super.copyPropertiesTo(target);
        if (target instanceof PlayerEntityExtendedModel) {
            PlayerEntityExtendedModel playerTarget = (PlayerEntityExtendedModel)target;
            this.copyAttributes(playerTarget);
        }
    }

    private void copyAttributes(PlayerEntityExtendedModel<T> target) {
        this.copyCommonAttributes(target);
        target.breasts.visible = this.breasts.visible;
        target.breasts.copyFrom(this.breasts);
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        this.renderCommon(matrices, vertices, light, overlay, color);
    }

    @Override
    public ModelPart getBreastPart() {
        return this.breasts;
    }

    @Override
    public ModelPart getBodyPart() {
        return this.body;
    }

    @Override
    public Iterable<ModelPart> getCommonHeadParts() {
        return this.headParts();
    }

    @Override
    public Iterable<ModelPart> getCommonBodyParts() {
        return this.bodyParts();
    }

    @Override
    public Iterable<ModelPart> getBreastParts() {
        return ImmutableList.of((Object)this.breasts);
    }

    @Override
    public VillagerDimensions.Mutable getDimensions() {
        return this.dimensions;
    }

    @Override
    public float getBreastSize() {
        return this.breastSize;
    }

    @Override
    public void setBreastSize(float breastSize) {
        this.breastSize = breastSize;
    }

    public void setupAnim(T villager, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        if (CommonVillagerModel.getVillager(villager).getAgeState() == AgeState.BABY && !villager.isPassenger()) {
            limbDistance = (float)Math.sin((float)((LivingEntity)villager).tickCount / 12.0f);
            limbAngle = (float)Math.cos((float)((LivingEntity)villager).tickCount / 9.0f) * 3.0f;
            headYaw += (float)Math.sin((float)((LivingEntity)villager).tickCount / 2.0f);
        }
        super.setupAnim(villager, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
        this.applyVillagerDimensions(CommonVillagerModel.getVillager(villager), villager.isCrouching());
    }
}

