/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.render.layer;

import net.conczin.mca.MCA;
import net.conczin.mca.client.model.CommonVillagerModel;
import net.conczin.mca.client.render.layer.VillagerLayer;
import net.conczin.mca.client.resources.ColorPalette;
import net.conczin.mca.entity.ai.Genetics;
import net.conczin.mca.entity.ai.Traits;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class SkinLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends VillagerLayer<T, M> {
    public SkinLayer(RenderLayerParent<T, M> renderer, M model) {
        super(renderer, model);
    }

    @Override
    public ResourceLocation getSkin(T villager) {
        Genetics genetics = CommonVillagerModel.getVillager(villager).getGenetics();
        int skin = (int)Math.min(4.0f, Math.max(0.0f, genetics.getGene(Genetics.SKIN) * 5.0f));
        return this.cached("skins/skin/" + genetics.getGender().getDataName() + "/" + skin + ".png", MCA::locate);
    }

    @Override
    public int getColor(T villager, float tickDelta) {
        float albinism = CommonVillagerModel.getVillager(villager).getTraits().hasTrait(Traits.ALBINISM) ? 0.1f : 1.0f;
        return ColorPalette.SKIN.getColor(CommonVillagerModel.getVillager(villager).getGenetics().getGene(Genetics.MELANIN) * albinism, CommonVillagerModel.getVillager(villager).getGenetics().getGene(Genetics.HEMOGLOBIN) * albinism, CommonVillagerModel.getVillager(villager).getInfectionProgress());
    }
}

