/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.resources;

import java.util.HashMap;
import java.util.Map;
import net.conczin.mca.MCA;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class ColorPalette {
    static final Data EMPTY = new Data(1, 1, new int[]{0xFFFFFF});
    static final Map<ResourceLocation, ColorPalette> REGISTRY = new HashMap<ResourceLocation, ColorPalette>();
    public static final ColorPalette SKIN = new ColorPalette(MCA.locate("textures/colormap/villager_skin.png"));
    public static final ColorPalette HAIR = new ColorPalette(MCA.locate("textures/colormap/villager_hair.png"));
    private final ResourceLocation id;
    Data data = EMPTY;

    public ColorPalette(ResourceLocation id) {
        this.id = id;
        REGISTRY.put(id, this);
    }

    private static int applyGreenShift(int color, float greenShift) {
        return FastColor.ARGB32.colorFromFloat((float)1.0f, (float)Mth.clamp((float)((float)FastColor.ARGB32.red((int)color) / 255.0f * (1.0f - greenShift * 0.3f) - greenShift * 0.1f), (float)0.0f, (float)1.0f), (float)Mth.clamp((float)((float)FastColor.ARGB32.green((int)color) / 255.0f * (1.0f + greenShift * 0.3f) + greenShift * 0.1f), (float)0.0f, (float)1.0f), (float)Mth.clamp((float)((float)FastColor.ARGB32.blue((int)color) / 255.0f), (float)0.0f, (float)1.0f));
    }

    private static int clampFloor(float v, int max) {
        return (int)Math.floor(Mth.clamp((float)(v * (float)max), (float)0.0f, (float)max));
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public int getColor(float u, float v, float greenShift) {
        int x = ColorPalette.clampFloor(v, this.data.width - 1);
        int y = ColorPalette.clampFloor(u, this.data.height - 1);
        int color = this.data.colors[y * this.data.height + x];
        return greenShift > 0.0f ? ColorPalette.applyGreenShift(color, greenShift) : color;
    }

    public record Data(int width, int height, int[] colors) {
    }
}

