/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.tts;

import java.util.Collection;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.conczin.mca.Config;
import net.conczin.mca.MCA;
import net.conczin.mca.client.tts.ElevenlabsSpeechManager;
import net.conczin.mca.client.tts.OnlineSpeechManager;
import net.conczin.mca.client.tts.Player2SpeechManager;
import net.conczin.mca.client.tts.RealtimeSpeechManager;
import net.conczin.mca.client.tts.sound.CustomEntityBoundSoundInstance;
import net.conczin.mca.client.tts.sound.SingleWeighedSoundEvents;
import net.conczin.mca.entity.CommonSpeechManager;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.Genetics;
import net.conczin.mca.util.LimitedLinkedHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.SampledFloat;
import net.minecraft.world.entity.Entity;

public class SpeechManager {
    public static final SpeechManager INSTANCE = new SpeechManager();
    private final Minecraft client;
    private final LimitedLinkedHashMap<UUID, EntityBoundSoundInstance> currentlyPlaying = new LimitedLinkedHashMap(10);
    private final RealtimeSpeechManager realtimeSpeechManager;
    private final Player2SpeechManager player2SpeechManager;
    private final ElevenlabsSpeechManager elevenlabsSpeechManager;
    private final OnlineSpeechManager onlineSpeechManager;
    private final RandomSource threadSafeRandom;
    private long lastHealthCheckTime;
    private boolean firstRun;

    public SpeechManager() {
        this.realtimeSpeechManager = new RealtimeSpeechManager(Config.getInstance().onlineTTSServer);
        this.player2SpeechManager = new Player2SpeechManager(Config.getInstance().player2Url);
        this.elevenlabsSpeechManager = new ElevenlabsSpeechManager();
        this.onlineSpeechManager = new OnlineSpeechManager();
        this.threadSafeRandom = RandomSource.createThreadSafe();
        this.lastHealthCheckTime = 0L;
        this.firstRun = true;
        this.client = Minecraft.getInstance();
    }

    public EntityBoundSoundInstance getSound(float pitch, Entity entity, ResourceLocation soundLocation) {
        Sound sound = new Sound(soundLocation, (SampledFloat)ConstantFloat.of((float)1.0f), (SampledFloat)ConstantFloat.of((float)1.0f), 1, Sound.Type.FILE, true, false, 16);
        SingleWeighedSoundEvents weightedSoundEvents = new SingleWeighedSoundEvents(sound, soundLocation, "");
        return new CustomEntityBoundSoundInstance(weightedSoundEvents, SoundEvent.createVariableRangeEvent((ResourceLocation)soundLocation), SoundSource.NEUTRAL, 1.0f, pitch, entity, this.threadSafeRandom.nextLong());
    }

    public void playSound(float pitch, Entity entity, ResourceLocation soundLocation) {
        this.client.execute(() -> this.client.getSoundManager().play((SoundInstance)INSTANCE.getSound(pitch, entity, soundLocation)));
    }

    public void onChatMessage(Component message, UUID sender) {
        ComponentContents content = message.getContents();
        if (CommonSpeechManager.INSTANCE.translations.containsKey(content)) {
            this.speak((String)CommonSpeechManager.INSTANCE.translations.get(content), sender, true);
        } else if (content instanceof PlainTextContents.LiteralContents) {
            PlainTextContents.LiteralContents literalContents = (PlainTextContents.LiteralContents)content;
            try {
                String string;
                String text = string = literalContents.text();
                this.speak(text, sender, false);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
    }

    private VillagerEntityMCA getSpeaker(Minecraft client, UUID sender) {
        if (client.level != null) {
            for (Entity entity : client.level.entitiesForRendering()) {
                if (!(entity instanceof VillagerEntityMCA)) continue;
                VillagerEntityMCA v = (VillagerEntityMCA)entity;
                if (!entity.getUUID().equals(sender)) continue;
                return v;
            }
        }
        return null;
    }

    private void speak(String phrase, UUID sender, boolean translatable) {
        Minecraft client = Minecraft.getInstance();
        if (client.level == null) {
            return;
        }
        if (this.currentlyPlaying.containsKey(sender) && client.getSoundManager().isActive((SoundInstance)this.currentlyPlaying.get(sender))) {
            return;
        }
        VillagerEntityMCA villager = this.getSpeaker(client, sender);
        if (villager == null) {
            return;
        }
        if (villager.isSpeechImpaired()) {
            return;
        }
        if (villager.isToYoungToSpeak()) {
            return;
        }
        float pitch = villager.getVoicePitch();
        float gene = villager.getGenetics().getGene(Genetics.VOICE_TONE);
        String gender = villager.getGenetics().getGender().binary().getDataName();
        if (Config.getInstance().enableOnlineTTS) {
            if (translatable) {
                if (Language.getInstance().has(phrase)) {
                    phrase = Language.getInstance().getOrDefault(phrase);
                } else {
                    MCA.LOGGER.warn("Tried to play a TTS sound for a non-translatable phrase: {}", (Object)phrase);
                    return;
                }
            }
            String gameLang = client.options.languageCode;
            switch (Config.getInstance().onlineTTSModel) {
                case "realtime": {
                    this.realtimeSpeechManager.play(phrase, gender, gameLang, pitch, gene, (Entity)villager, translatable);
                    break;
                }
                case "player2": {
                    this.player2SpeechManager.play(phrase, gender, gameLang, pitch, gene);
                    break;
                }
                case "elevenlabs": {
                    this.elevenlabsSpeechManager.play(phrase, gender, pitch, gene, (Entity)villager, translatable);
                    break;
                }
                default: {
                    this.onlineSpeechManager.play(phrase, gameLang, gender, pitch, gene, (Entity)villager, translatable);
                    break;
                }
            }
        } else if (translatable) {
            Collection keys;
            int tone = Math.min(9, (int)Math.floor(gene * 10.0f));
            ResourceLocation sound = ResourceLocation.fromNamespaceAndPath((String)"mca_voices", (String)(phrase.toLowerCase(Locale.ROOT) + "/" + gender + "_" + tone));
            if (client.level != null && client.player != null && (keys = client.getSoundManager().getAvailableSounds()).contains(sound)) {
                EntityBoundSoundInstance instance = new EntityBoundSoundInstance(SoundEvent.createVariableRangeEvent((ResourceLocation)sound), SoundSource.NEUTRAL, 1.0f, pitch, (Entity)villager, this.threadSafeRandom.nextLong());
                this.currentlyPlaying.put(sender, instance);
                client.getSoundManager().play((SoundInstance)instance);
            }
        }
    }

    public void tick(Minecraft client) {
        long time;
        if (client.level != null && Math.abs((time = client.level.getGameTime()) - this.lastHealthCheckTime) > 1200L) {
            boolean enabled = Config.getInstance().villagerChatAIModel.equals("player2");
            if (this.firstRun || enabled) {
                CompletableFuture.runAsync(() -> {
                    if (this.player2SpeechManager.checkHealth() && this.firstRun && !enabled) {
                        client.gui.getChat().addMessage((Component)Component.translatable((String)"command.chat_ai.player2.hint", (Object[])new Object[]{"/mca chatAI player2"}));
                        this.firstRun = false;
                    }
                });
            }
            this.lastHealthCheckTime = time;
        }
    }
}

