/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai;

import java.util.Optional;
import java.util.UUID;
import java.util.function.BiPredicate;
import net.conczin.mca.Config;
import net.conczin.mca.block.TombstoneBlock;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.entity.ai.ActivitiesMCA;
import net.conczin.mca.entity.ai.relationship.CompassionateEntity;
import net.conczin.mca.entity.ai.relationship.EntityRelationship;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.entity.ai.relationship.RelationshipType;
import net.conczin.mca.entity.interaction.gifts.GiftSaturation;
import net.conczin.mca.registry.BlocksMCA;
import net.conczin.mca.registry.TagsMCA;
import net.conczin.mca.server.world.data.FamilyTree;
import net.conczin.mca.server.world.data.FamilyTreeNode;
import net.conczin.mca.server.world.data.GraveyardManager;
import net.conczin.mca.util.WorldUtils;
import net.conczin.mca.util.network.datasync.CDataManager;
import net.conczin.mca.util.network.datasync.CParameter;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Relationship<T extends Mob>
implements EntityRelationship {
    public static final Predicate IS_MARRIED = (villager, player) -> villager.getRelationships().isMarriedTo(player);
    public static final Predicate IS_ENGAGED = (villager, player) -> villager.getRelationships().isEngagedWith(player);
    public static final Predicate IS_PROMISED = (villager, player) -> villager.getRelationships().isPromisedTo(player);
    public static final Predicate IS_RELATIVE = (villager, player) -> villager.getRelationships().getFamilyEntry().isRelative(player);
    public static final Predicate IS_FAMILY = IS_MARRIED.or(IS_RELATIVE);
    public static final Predicate IS_PARENT = (villager, player) -> villager.getRelationships().getFamilyEntry().isParent(player);
    public static final Predicate IS_KID = (villager, player) -> FamilyTree.get(villager.getRelationships().getWorld()).getOrEmpty(player).filter(n -> n.isParent(villager.getRelationships().getUUID())).isPresent();
    public static final Predicate IS_ORPHAN = (villager, player) -> villager.getRelationships().getFamilyEntry().getParents().allMatch(FamilyTreeNode::isDeceased);
    protected final T entity;
    private final GiftSaturation giftSaturation = new GiftSaturation();

    public Relationship(T entity) {
        this.entity = entity;
    }

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(new CParameter[0]);
    }

    @Override
    public Gender getGender() {
        return ((VillagerLike)this.entity).getGenetics().getGender();
    }

    @Override
    public ServerLevel getWorld() {
        return (ServerLevel)this.entity.level();
    }

    @Override
    public UUID getUUID() {
        return this.entity.getUUID();
    }

    @Override
    @NotNull
    public FamilyTreeNode getFamilyEntry() {
        return this.getFamilyTree().getOrCreate((Entity)this.entity);
    }

    private Optional<BlockPos> placeTombstone(ServerLevel world, BlockPos entityPos) {
        int range = 2;
        for (int y = -range; y <= range; ++y) {
            BlockPos pos = entityPos.offset(0, y, 0);
            if (world.getBlockState(pos).isAir()) {
                world.setBlockAndUpdate(pos, BlocksMCA.CROSS_HEADSTONE.defaultBlockState());
                return Optional.ofNullable(pos);
            }
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    if (x == 0 && z == 0 || !world.getBlockState(pos = entityPos.offset(x, y, z)).isAir()) continue;
                    world.setBlockAndUpdate(pos, BlocksMCA.CROSS_HEADSTONE.defaultBlockState());
                    return Optional.ofNullable(pos);
                }
            }
        }
        return Optional.empty();
    }

    public void onDeath(DamageSource cause) {
        boolean beRemembered = this.getFamilyEntry().willBeRemembered();
        boolean beLoved = ((VillagerLike)this.entity).getVillagerBrain().getMemories().values().stream().anyMatch(m -> m.getHearts() > Config.getInstance().heartsRequiredToAutoSpawnGravestone);
        if (beRemembered || beLoved || !((VillagerLike)this.entity).isHostile()) {
            this.getFamilyEntry().setDeceased(true);
            ServerLevel world = (ServerLevel)this.entity.level();
            Optional<BlockPos> nearest = GraveyardManager.get(world).findNearest(this.entity.blockPosition(), GraveyardManager.TombstoneState.EMPTY, 10);
            if ((beRemembered || beLoved) && nearest.isEmpty()) {
                nearest = this.placeTombstone(world, this.entity.blockPosition());
            }
            nearest.ifPresentOrElse(pos -> {
                BlockEntity patt0$temp;
                if (this.entity.level().getBlockState(pos).is(TagsMCA.Blocks.TOMBSTONES) && (patt0$temp = this.entity.level().getBlockEntity(pos)) instanceof TombstoneBlock.Data) {
                    TombstoneBlock.Data tombstone = (TombstoneBlock.Data)patt0$temp;
                    this.onTragedy(cause, (BlockPos)pos);
                    tombstone.setEntity((Entity)this.entity);
                } else {
                    this.onTragedy(cause, null);
                }
            }, () -> this.onTragedy(cause, null));
        } else {
            this.onTragedy(cause, null);
        }
        if (!beRemembered) {
            this.getFamilyEntry().streamParents().forEach(uuid -> this.getFamilyTree().remove((UUID)uuid));
            this.getFamilyTree().remove(this.entity.getUUID());
        }
    }

    public void onTragedy(DamageSource cause, @Nullable BlockPos burialSite) {
        if (!((VillagerLike)this.entity).isHostile()) {
            WorldUtils.getCloseEntities(this.entity.level(), this.entity, 32.0, VillagerEntityMCA.class).forEach(villager -> villager.getRelationships().onTragedy(cause, burialSite, RelationshipType.STRANGER, (Entity)this.entity));
        }
        this.onTragedy(cause, burialSite, RelationshipType.SELF, (Entity)this.entity);
    }

    @Override
    public void onTragedy(DamageSource cause, @Nullable BlockPos burialSite, RelationshipType type, Entity with) {
        if (!cause.is(DamageTypes.FELL_OUT_OF_WORLD)) {
            int moodAffect = 5 * type.getProximityAmplifier();
            this.entity.level().broadcastEntityEvent(this.entity, (byte)17);
            ((VillagerLike)this.entity).getVillagerBrain().modifyMoodValue(-moodAffect);
            Entity entity = cause.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                ((VillagerLike)this.entity).getVillagerBrain().getMemoriesForPlayer(player).modHearts(-20);
            }
        }
        if (burialSite != null && type != RelationshipType.STRANGER) {
            ((VillagerLike)this.entity).getVillagerBrain().setGrieving();
            this.entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(burialSite, 1.0f, 1));
            this.entity.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(burialSite));
            this.entity.getBrain().setActiveActivityIfPossible(ActivitiesMCA.GRIEVE);
        }
        EntityRelationship.super.onTragedy(cause, burialSite, type, with);
    }

    public GiftSaturation getGiftSaturation() {
        return this.giftSaturation;
    }

    public void readFromNbt(CompoundTag nbt) {
        this.giftSaturation.readFromNbt(nbt.getList("GiftSaturationQueue", 8));
    }

    public void writeToNbt(CompoundTag nbt) {
        nbt.put("GiftSaturationQueue", (Tag)this.giftSaturation.toNbt());
    }

    public static interface Predicate
    extends BiPredicate<CompassionateEntity<?>, Entity> {
        @Override
        public boolean test(CompassionateEntity<?> var1, UUID var2);

        @Override
        default public boolean test(CompassionateEntity<?> villager, Entity partner) {
            return partner != null && this.test(villager, partner.getUUID());
        }

        default public Predicate or(Predicate b) {
            return (villager, partner) -> this.test(villager, partner) || b.test(villager, partner);
        }

        default public Predicate negate() {
            return (villager, partner) -> !this.test(villager, partner);
        }

        default public BiPredicate<VillagerLike<?>, ServerPlayer> asConstraint() {
            return (villager, player) -> villager instanceof CompassionateEntity && this.test((CompassionateEntity)((Object)villager), (Entity)player);
        }
    }
}

