/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai;

import java.util.Optional;
import java.util.stream.Stream;
import net.conczin.mca.Config;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.MemoryModuleTypeMCA;
import net.conczin.mca.entity.ai.MoveState;
import net.conczin.mca.server.world.data.GraveyardManager;
import net.conczin.mca.server.world.data.Village;
import net.conczin.mca.server.world.data.VillageManager;
import net.conczin.mca.util.network.datasync.CDataManager;
import net.conczin.mca.util.network.datasync.CDataParameter;
import net.conczin.mca.util.network.datasync.CParameter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;

public class Residency {
    private static final CDataParameter<Integer> VILLAGE = CParameter.create("HomeVillage", -1);
    private final VillagerEntityMCA entity;

    public Residency(VillagerEntityMCA entity) {
        this.entity = entity;
    }

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(VILLAGE);
    }

    public BlockPos getWorkplace() {
        return this.entity.getBrain().getMemoryInternal(MemoryModuleType.JOB_SITE).map(GlobalPos::pos).orElse(BlockPos.ZERO);
    }

    public void setWorkplace(ServerPlayer player) {
        PoiManager pointOfInterestStorage = ((ServerLevel)player.level()).getPoiManager();
        pointOfInterestStorage.findClosest(VillagerProfession.NONE.acquirableJobSite(), a -> true, this.entity.blockPosition(), 8, PoiManager.Occupancy.HAS_SPACE).ifPresentOrElse(blockPos -> pointOfInterestStorage.getType(blockPos).ifPresent(pointOfInterestType -> {
            pointOfInterestStorage.take(VillagerProfession.NONE.acquirableJobSite(), (registryEntry, blockPos2) -> blockPos2.equals(blockPos), blockPos, 1);
            this.entity.releasePoi(MemoryModuleType.POTENTIAL_JOB_SITE);
            this.entity.getBrain().eraseMemory(MemoryModuleType.POTENTIAL_JOB_SITE);
            this.entity.releasePoi(MemoryModuleType.JOB_SITE);
            this.entity.getBrain().eraseMemory(MemoryModuleType.JOB_SITE);
            GlobalPos globalPos = GlobalPos.of((ResourceKey)player.level().dimension(), (BlockPos)blockPos);
            this.entity.getBrain().setMemory(MemoryModuleType.JOB_SITE, (Object)globalPos);
            player.level().broadcastEntityEvent((Entity)this.entity, (byte)14);
            MinecraftServer minecraftServer = player.level().getServer();
            Optional.ofNullable(minecraftServer.getLevel(globalPos.dimension())).flatMap(world -> world.getPoiManager().getType(globalPos.pos())).flatMap(registryEntry -> BuiltInRegistries.VILLAGER_PROFESSION.stream().filter(profession -> profession.heldJobSite().test(registryEntry)).findFirst()).ifPresent(profession -> {
                int level = this.entity.getVillagerData().getLevel();
                this.entity.setVillagerData(this.entity.getVillagerData().setProfession(profession).setLevel(1));
                this.entity.setOffers(null);
                this.entity.getOffers();
                for (int l = 1; l < level; ++l) {
                    this.entity.customLevelUp();
                }
                this.entity.refreshBrain((ServerLevel)player.level());
            });
            this.entity.sendChatMessage((Player)player, "interaction.setworkplace.success", new Object[0]);
        }), () -> this.entity.sendChatMessage((Player)player, "interaction.setworkplace.failed", new Object[0]));
    }

    public Optional<Village> getHomeVillage() {
        VillageManager manager = VillageManager.get((ServerLevel)this.entity.level());
        return manager.getOrEmpty((Integer)this.entity.getTrackedValue(VILLAGE));
    }

    public void seekHome() {
        if (this.entity.requiresHome()) {
            VillageManager manager = VillageManager.get((ServerLevel)this.entity.level());
            manager.findNearestVillage((Entity)this.entity).ifPresent(v -> {
                this.leaveHome();
                v.updateResident(this.entity);
                this.entity.setTrackedValue(VILLAGE, v.getId());
            });
        }
    }

    public void leaveHome() {
        Optional<Village> village = this.getHomeVillage();
        village.ifPresent(v -> v.removeResident(this.entity));
        this.entity.setTrackedValue(VILLAGE, -1);
    }

    public void tick() {
        if (this.entity.tickCount % 600 == 0 && this.entity.requiresHome()) {
            Optional<Village> village2 = this.getHomeVillage();
            if (village2.isEmpty() && Config.getInstance().enableAutoScanByDefault || village2.filter(Village::isAutoScan).isPresent()) {
                this.reportBuildings();
            }
            if (village2.isEmpty()) {
                this.seekHome();
            }
        }
        if (this.entity.tickCount % 1200 == 0) {
            this.getHomeVillage().ifPresentOrElse(village -> this.entity.level().players().forEach(player -> {
                int hearts = this.entity.getVillagerBrain().getMemoriesForPlayer((Player)player).getHearts();
                village.setReputation((Player)player, this.entity, hearts);
            }), this::leaveHome);
        }
    }

    private void reportBuildings() {
        VillageManager manager = VillageManager.get((ServerLevel)this.entity.level());
        Stream stream = ((ServerLevel)this.entity.level()).getPoiManager().findAll(type -> true, p -> !manager.cache.contains(p), this.entity.blockPosition(), 48, PoiManager.Occupancy.ANY);
        stream.forEach(manager::reportBuilding);
        GraveyardManager.get((ServerLevel)this.entity.level()).reportToVillageManager((Entity)this.entity);
    }

    public Optional<GlobalPos> getHome() {
        return this.entity.getMCABrain().getMemoryInternal(MemoryModuleType.HOME);
    }

    public void setHome(ServerPlayer player) {
        if (!this.entity.requiresHome()) {
            this.entity.sendChatMessage((Player)player, "interaction.sethome.temporary", new Object[0]);
            return;
        }
        VillageManager manager = VillageManager.get((ServerLevel)player.level());
        manager.processBuilding(player.blockPosition(), true, false);
        this.seekHome();
        PoiManager pointOfInterestStorage = ((ServerLevel)player.level()).getPoiManager();
        Optional position = pointOfInterestStorage.findAll(registryEntry -> registryEntry.is(PoiTypes.HOME), p -> true, player.blockPosition(), 8, PoiManager.Occupancy.HAS_SPACE).findAny();
        if (position.isPresent()) {
            this.entity.sendChatMessage((Player)player, "interaction.sethome.success", new Object[0]);
            this.entity.getBrain().getMemoryInternal(MemoryModuleType.HOME).ifPresent(p -> {
                this.entity.releasePoi(MemoryModuleType.HOME);
                this.entity.getBrain().eraseMemory(MemoryModuleType.HOME);
            });
            pointOfInterestStorage.take(registryEntry -> registryEntry.is(PoiTypes.HOME), (p, q) -> true, (BlockPos)position.get(), 1);
            this.entity.getBrain().setMemory(MemoryModuleType.HOME, (Object)GlobalPos.of((ResourceKey)this.entity.level().dimension(), (BlockPos)((BlockPos)position.get())));
            this.entity.getBrain().setMemory(MemoryModuleTypeMCA.FORCED_HOME, (Object)true);
            this.seekHome();
        } else {
            this.entity.getBrain().eraseMemory(MemoryModuleTypeMCA.FORCED_HOME);
            this.getHomeVillage().map(v -> v.getBuildingAt((Vec3i)this.entity.blockPosition())).filter(Optional::isPresent).map(Optional::get).filter(b -> b.getBuildingType().noBeds()).ifPresentOrElse(building -> this.entity.sendChatMessage((Player)player, "interaction.sethome.bedfail." + building.getBuildingType().name(), new Object[0]), () -> this.entity.sendChatMessage((Player)player, "interaction.sethome.bedfail", new Object[0]));
        }
    }

    public void goHome(Player player) {
        this.entity.getVillagerBrain().setMoveState(MoveState.MOVE, player);
        this.entity.getInteractions().stopInteracting();
        this.getHome().filter(p -> p.dimension() == this.entity.level().dimension()).ifPresentOrElse(home -> {
            this.entity.moveTowards(home.pos());
            this.entity.sendChatMessage(player, "interaction.gohome.success", new Object[0]);
        }, () -> this.entity.sendChatMessage(player, "interaction.gohome.fail.nohome", new Object[0]));
    }
}

