/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.ai.brain.sensor.ExplodingCreeperSensor;
import net.conczin.mca.entity.ai.brain.sensor.GuardEnemiesSensor;
import net.conczin.mca.entity.ai.brain.sensor.VillagerMCABabiesSensor;
import net.conczin.mca.mixin.MixinSensorType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;

public interface SensorsMCA {
    public static final Map<ResourceLocation, SensorType<?>> SENSORS = new HashMap();
    public static final SensorType<ExplodingCreeperSensor> EXPLODING_CREEPER = SensorsMCA.sensor("exploding_creeper", ExplodingCreeperSensor::new);
    public static final SensorType<GuardEnemiesSensor> GUARD_ENEMIES = SensorsMCA.sensor("guard_enemies", GuardEnemiesSensor::new);
    public static final SensorType<VillagerMCABabiesSensor> VILLAGER_BABIES = SensorsMCA.sensor("villager_babies_mca", VillagerMCABabiesSensor::new);

    public static <T extends Sensor<?>> SensorType<T> sensor(String name, Supplier<T> factory) {
        SensorType<T> sensor = MixinSensorType.init(factory);
        SENSORS.put(MCA.locate(name), sensor);
        return sensor;
    }

    public static void registerSensors(MCA.RegisterHelper<SensorType<?>> helper) {
        SENSORS.forEach(helper::register);
    }
}

