/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.conczin.mca.Config;
import net.conczin.mca.entity.EntityWrapper;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.entity.ai.ActivitiesMCA;
import net.conczin.mca.entity.ai.Chore;
import net.conczin.mca.entity.ai.Memories;
import net.conczin.mca.entity.ai.MemoryModuleTypeMCA;
import net.conczin.mca.entity.ai.Mood;
import net.conczin.mca.entity.ai.MoodGroup;
import net.conczin.mca.entity.ai.MoveState;
import net.conczin.mca.entity.ai.relationship.Personality;
import net.conczin.mca.registry.CriterionMCA;
import net.conczin.mca.util.network.datasync.CDataManager;
import net.conczin.mca.util.network.datasync.CDataParameter;
import net.conczin.mca.util.network.datasync.CEnumParameter;
import net.conczin.mca.util.network.datasync.CParameter;
import net.conczin.mca.util.network.datasync.CTrackedEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import org.jetbrains.annotations.Nullable;

public class VillagerBrain<E extends Mob> {
    private static final CDataParameter<CompoundTag> MEMORIES = CParameter.create("Memories", new CompoundTag());
    private static final CEnumParameter<Personality> PERSONALITY = CParameter.create("Personality", Personality.UNASSIGNED);
    private static final CDataParameter<Integer> MOOD = CParameter.create("Mood", 0);
    private static final CEnumParameter<MoveState> MOVE_STATE = CParameter.create("MoveState", MoveState.MOVE);
    private static final CEnumParameter<Chore> ACTIVE_CHORE = CParameter.create("ActiveChore", Chore.NONE);
    private static final CDataParameter<Optional<UUID>> CHORE_ASSIGNING_PLAYER = CParameter.create("ChoreAssigningPlayer", Optional.empty());
    private static final CDataParameter<Boolean> PANICKING = CParameter.create("IsPanicking", false);
    private static final CDataParameter<Boolean> WEAR_ARMOR = CParameter.create("WearArmor", false);
    private static final long GRIEVE_COOLDOWN = 168000L;
    private final Random random = new Random();
    private final E entity;

    public VillagerBrain(E entity) {
        this.entity = entity;
    }

    public static <E2 extends Entity> CDataManager.Builder<E2> createTrackedData(CDataManager.Builder<E2> builder) {
        return builder.addAll(MEMORIES, PERSONALITY, MOOD, MOVE_STATE, ACTIVE_CHORE, CHORE_ASSIGNING_PLAYER, PANICKING, WEAR_ARMOR);
    }

    public void think() {
        CompoundTag nbt;
        boolean panicking;
        if (((CTrackedEntity)this.entity).getTrackedValue(ACTIVE_CHORE) != Chore.NONE) {
            this.entity.getBrain().getActiveNonCoreActivity().ifPresent(activity -> {
                if (!activity.equals((Object)ActivitiesMCA.CHORE)) {
                    this.entity.getBrain().setActiveActivityIfPossible(ActivitiesMCA.CHORE);
                }
            });
        }
        if ((panicking = this.entity.getBrain().isActive(Activity.PANIC)) != (Boolean)((CTrackedEntity)this.entity).getTrackedValue(PANICKING)) {
            ((CTrackedEntity)this.entity).setTrackedValue(PANICKING, panicking);
        }
        if (((Mob)this.entity).tickCount % 20 != 0) {
            this.updateMoveState();
        }
        if (((Mob)this.entity).tickCount % Math.max(1, Config.getInstance().interactionFatigueCooldown) == 0 && (nbt = (CompoundTag)((CTrackedEntity)this.entity).getTrackedValue(MEMORIES)) != null) {
            for (String uuid : nbt.getAllKeys()) {
                Memories memories = Memories.fromCNBT(this.entity, nbt.getCompound(uuid));
                int fatigue = memories.getInteractionFatigue();
                if (fatigue <= 0) continue;
                memories.setInteractionFatigue(fatigue - 1);
            }
        }
    }

    public Chore getCurrentJob() {
        return (Chore)((Object)((CTrackedEntity)this.entity).getTrackedValue(ACTIVE_CHORE));
    }

    public Optional<Player> getJobAssigner() {
        return ((Optional)((CTrackedEntity)this.entity).getTrackedValue(CHORE_ASSIGNING_PLAYER)).map(id -> this.entity.level().getPlayerByUUID(id));
    }

    public void abandonJob() {
        this.entity.getBrain().setActiveActivityIfPossible(Activity.IDLE);
        ((CTrackedEntity)this.entity).setTrackedValue(ACTIVE_CHORE, Chore.NONE);
        ((CTrackedEntity)this.entity).setTrackedValue(CHORE_ASSIGNING_PLAYER, Optional.empty());
        this.resetsBrain();
    }

    public void assignJob(Chore chore, Player player) {
        this.entity.getBrain().setActiveActivityIfPossible(ActivitiesMCA.CHORE);
        ((CTrackedEntity)this.entity).setTrackedValue(ACTIVE_CHORE, chore);
        ((CTrackedEntity)this.entity).setTrackedValue(CHORE_ASSIGNING_PLAYER, Optional.of(player.getUUID()));
        this.entity.getBrain().eraseMemory(MemoryModuleTypeMCA.PLAYER_FOLLOWING);
        this.entity.getBrain().eraseMemory(MemoryModuleTypeMCA.STAYING);
        this.resetsBrain();
    }

    public void randomize() {
        ((CTrackedEntity)this.entity).setTrackedValue(PERSONALITY, Personality.getRandom());
        ((CTrackedEntity)this.entity).setTrackedValue(MOOD, this.entity.level().random.nextInt(31) + -15);
    }

    public void updateMemories(Memories memories) {
        CompoundTag nbt = (CompoundTag)((CTrackedEntity)this.entity).getTrackedValue(MEMORIES);
        nbt = nbt == null ? new CompoundTag() : nbt.copy();
        nbt.put(memories.getPlayerUUID().toString(), (Tag)memories.toCNBT());
        ((CTrackedEntity)this.entity).setTrackedValue(MEMORIES, nbt);
    }

    public Map<UUID, Memories> getMemories() {
        CompoundTag nbt = (CompoundTag)((CTrackedEntity)this.entity).getTrackedValue(MEMORIES);
        HashMap<UUID, Memories> memories = new HashMap<UUID, Memories>();
        for (String uuid : nbt.getAllKeys()) {
            memories.put(UUID.fromString(uuid), Memories.fromCNBT(this.entity, nbt.getCompound(uuid)));
        }
        return memories;
    }

    public Memories getMemoriesForPlayer(Player player) {
        CompoundTag nbt = (CompoundTag)((CTrackedEntity)this.entity).getTrackedValue(MEMORIES);
        nbt = nbt == null ? new CompoundTag() : nbt;
        CompoundTag compoundTag = nbt.getCompound(player.getUUID().toString());
        Memories returnMemories = Memories.fromCNBT(this.entity, compoundTag);
        if (returnMemories == null) {
            returnMemories = new Memories(this, player.level().getDayTime(), player.getUUID());
            nbt.put(player.getUUID().toString(), (Tag)returnMemories.toCNBT());
            ((CTrackedEntity)this.entity).setTrackedValue(MEMORIES, nbt);
        }
        return returnMemories;
    }

    public Personality getPersonality() {
        return (Personality)((Object)((CTrackedEntity)this.entity).getTrackedValue(PERSONALITY));
    }

    public void setPersonality(Personality p) {
        ((CTrackedEntity)this.entity).setTrackedValue(PERSONALITY, p);
    }

    public Mood getMood() {
        return MoodGroup.INSTANCE.getMood((Integer)((CTrackedEntity)this.entity).getTrackedValue(MOOD));
    }

    public boolean isPanicking() {
        return (Boolean)((CTrackedEntity)this.entity).getTrackedValue(PANICKING);
    }

    public void modifyMoodValue(int mood) {
        ((CTrackedEntity)this.entity).setTrackedValue(MOOD, MoodGroup.clampMood(this.getMoodValue() + mood));
    }

    public int getMoodValue() {
        return (Integer)((CTrackedEntity)this.entity).getTrackedValue(MOOD);
    }

    public MoveState getMoveState() {
        return (MoveState)((Object)((CTrackedEntity)this.entity).getTrackedValue(MOVE_STATE));
    }

    public void setMoveState(MoveState state, @Nullable Player leader) {
        ((CTrackedEntity)this.entity).setTrackedValue(MOVE_STATE, state);
        if (state == MoveState.MOVE) {
            this.entity.getBrain().eraseMemory(MemoryModuleTypeMCA.PLAYER_FOLLOWING);
            this.entity.getBrain().eraseMemory(MemoryModuleTypeMCA.STAYING);
        }
        if (state == MoveState.STAY) {
            this.entity.getBrain().eraseMemory(MemoryModuleTypeMCA.PLAYER_FOLLOWING);
            this.entity.getBrain().setMemory(MemoryModuleTypeMCA.STAYING, (Object)true);
        }
        if (state == MoveState.FOLLOW) {
            this.entity.getBrain().setMemory(MemoryModuleTypeMCA.PLAYER_FOLLOWING, (Object)leader);
            this.entity.getBrain().eraseMemory(MemoryModuleTypeMCA.STAYING);
            this.abandonJob();
        }
        this.resetsBrain();
    }

    private void resetsBrain() {
        Mob mob = ((EntityWrapper)this.entity).asEntity();
        if (mob instanceof VillagerEntityMCA) {
            VillagerEntityMCA villager = (VillagerEntityMCA)mob;
            villager.refreshBrain((ServerLevel)villager.level());
        }
    }

    public boolean getArmorWear() {
        return (Boolean)((CTrackedEntity)this.entity).getTrackedValue(WEAR_ARMOR);
    }

    public void setArmorWear(boolean s) {
        ((CTrackedEntity)this.entity).setTrackedValue(WEAR_ARMOR, s);
    }

    public void setGrieving() {
        this.entity.getBrain().setMemory(MemoryModuleTypeMCA.LAST_GRIEVE, (Object)-168000L);
    }

    public void justGrieved() {
        this.entity.getBrain().setMemory(MemoryModuleTypeMCA.LAST_GRIEVE, (Object)this.entity.level().getGameTime());
    }

    public boolean shouldGrieve() {
        Optional memory = this.entity.getBrain().getMemoryInternal(MemoryModuleTypeMCA.LAST_GRIEVE);
        if (memory.isPresent()) {
            return this.entity.level().getGameTime() - (Long)memory.get() > 168000L;
        }
        this.entity.getBrain().setMemory(MemoryModuleTypeMCA.LAST_GRIEVE, (Object)(this.entity.level().getGameTime() - this.random.nextLong(168000L)));
        return false;
    }

    public void updateMoveState() {
        if (this.getMoveState() == MoveState.FOLLOW && this.entity.getBrain().getMemoryInternal(MemoryModuleTypeMCA.PLAYER_FOLLOWING).isEmpty()) {
            if (this.entity.getBrain().getMemoryInternal(MemoryModuleTypeMCA.STAYING).isPresent()) {
                ((CTrackedEntity)this.entity).setTrackedValue(MOVE_STATE, MoveState.STAY);
            } else if (this.entity.getBrain().getMemoryInternal(MemoryModuleTypeMCA.PLAYER_FOLLOWING).isPresent()) {
                ((CTrackedEntity)this.entity).setTrackedValue(MOVE_STATE, MoveState.FOLLOW);
            } else {
                ((CTrackedEntity)this.entity).setTrackedValue(MOVE_STATE, MoveState.MOVE);
            }
        }
    }

    public void rewardHearts(ServerPlayer player, int hearts) {
        Memories memory = ((VillagerLike)this.entity).getVillagerBrain().getMemoriesForPlayer((Player)player);
        if (hearts == 0) {
            return;
        }
        if (hearts > 0) {
            this.entity.level().broadcastEntityEvent(this.entity, (byte)16);
        } else {
            this.entity.level().broadcastEntityEvent(this.entity, (byte)15);
            if (((VillagerLike)this.entity).getVillagerBrain().getPersonality() == Personality.SENSITIVE) {
                hearts *= 2;
            }
        }
        memory.modInteractionFatigue(1);
        memory.modHearts(hearts);
        CriterionMCA.HEARTS.trigger(player, memory.getHearts(), hearts, "interaction");
        ((VillagerLike)this.entity).getVillagerBrain().modifyMoodValue(hearts);
    }
}

