/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks;

import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;

public class ConditionalTask<E extends LivingEntity>
extends Behavior<E> {
    private final Behavior<? super E> task;
    private final Predicate<E> predicate;

    public ConditionalTask(Behavior<? super E> task, Predicate<E> predicate) {
        super(Map.of());
        this.task = task;
        this.predicate = predicate;
    }

    protected void start(ServerLevel world, E entity, long time) {
        this.task.tryStart(world, entity, time);
    }

    protected void tick(ServerLevel world, E entity, long time) {
        this.task.tickOrStop(world, entity, time);
    }

    protected void stop(ServerLevel world, E entity, long time) {
        this.task.doStop(world, entity, time);
    }

    protected boolean canStillUse(ServerLevel world, E entity, long time) {
        return this.task.getStatus() == Behavior.Status.RUNNING;
    }

    protected boolean checkExtraStartConditions(ServerLevel world, E entity) {
        return this.predicate.test(entity);
    }

    protected boolean timedOut(long time) {
        return false;
    }
}

