/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class ExtendedWalkTowardsTask {
    public static OneShot<VillagerEntityMCA> create(MemoryModuleType<GlobalPos> destination, float speed, int completionRange, int maxDistance, int maxRunTime, Predicate<VillagerEntityMCA> canGiveUp, Consumer<VillagerEntityMCA> onGiveUp) {
        return BehaviorBuilder.create(context -> context.group((App)context.registered(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE), (App)context.absent(MemoryModuleType.WALK_TARGET), (App)context.present(destination)).apply((Applicative)context, (cantReachWalkTargetSince, walkTarget, destinationResult) -> (world, entity, time) -> {
            GlobalPos globalPos = (GlobalPos)context.get(destinationResult);
            Optional optional = context.tryGet(cantReachWalkTargetSince);
            if (globalPos.dimension() == world.dimension() && (optional.isEmpty() || world.getGameTime() - (Long)optional.get() <= (long)maxRunTime)) {
                if (globalPos.pos().distManhattan((Vec3i)entity.blockPosition()) > maxDistance) {
                    Vec3 vec3d = null;
                    int l = 0;
                    while (vec3d == null || BlockPos.containing(vec3d).distManhattan((Vec3i)entity.blockPosition()) > maxDistance) {
                        vec3d = DefaultRandomPos.getPosTowards((PathfinderMob)entity, (int)15, (int)7, (Vec3)Vec3.atBottomCenterOf((Vec3i)globalPos.pos()), (double)1.5707963705062866);
                        if (++l != 1000) continue;
                        entity.releasePoi(destination);
                        destinationResult.erase();
                        cantReachWalkTargetSince.set((Object)time);
                        return true;
                    }
                    walkTarget.set((Object)new WalkTarget(vec3d, speed, completionRange));
                } else if (globalPos.pos().distManhattan((Vec3i)entity.blockPosition()) > completionRange) {
                    walkTarget.set((Object)new WalkTarget(globalPos.pos(), speed, completionRange));
                }
            } else if (canGiveUp.test((VillagerEntityMCA)entity)) {
                entity.releasePoi(destination);
                destinationResult.erase();
                cantReachWalkTargetSince.set((Object)time);
                onGiveUp.accept((VillagerEntityMCA)entity);
            } else {
                cantReachWalkTargetSince.set((Object)time);
            }
            return true;
        }));
    }
}

