/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.Chore;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;

public class InteractTask
extends Behavior<VillagerEntityMCA> {
    private final float speedModifier;

    public InteractTask(float speedModifier) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED), Integer.MAX_VALUE);
        this.speedModifier = speedModifier;
    }

    public static boolean shouldRun(VillagerEntityMCA villager) {
        return villager.isAlive() && villager.getInteractions().getInteractingPlayer().filter(player -> villager.distanceToSqr((Entity)player) <= 25.0).isPresent() && !villager.isInWater() && !villager.hurtMarked && villager.getVillagerBrain().getCurrentJob() == Chore.NONE;
    }

    protected boolean checkExtraStartConditions(ServerLevel world, VillagerEntityMCA villager) {
        return InteractTask.shouldRun(villager);
    }

    protected boolean canStillUse(ServerLevel world, VillagerEntityMCA villager, long time) {
        return this.checkExtraStartConditions(world, villager);
    }

    protected void start(ServerLevel world, VillagerEntityMCA villager, long time) {
        this.followPlayer(villager);
    }

    protected void stop(ServerLevel world, VillagerEntityMCA villager, long time) {
        Brain brain = villager.getBrain();
        brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        brain.eraseMemory(MemoryModuleType.LOOK_TARGET);
    }

    protected void tick(ServerLevel world, VillagerEntityMCA villager, long time) {
        this.followPlayer(villager);
    }

    protected boolean timedOut(long time) {
        return false;
    }

    private void followPlayer(VillagerEntityMCA villager) {
        Brain brain = villager.getBrain();
        villager.getInteractions().getInteractingPlayer().ifPresentOrElse(player -> {
            brain.setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((Entity)player, this.speedModifier, 2));
            brain.setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)player, true));
        }, () -> {
            brain.eraseMemory(MemoryModuleType.WALK_TARGET);
            brain.eraseMemory(MemoryModuleType.LOOK_TARGET);
        });
    }
}

