/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks;

import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class SequenceTask<E extends LivingEntity>
extends Behavior<E> {
    private final List<BehaviorControl<? super E>> tasks;
    int progress = 0;

    public SequenceTask(Map<MemoryModuleType<?>, MemoryStatus> requiredMemoryState, List<BehaviorControl<? super E>> tasks) {
        super(requiredMemoryState);
        this.tasks = tasks;
    }

    private BehaviorControl<? super E> getRunningTask() {
        return this.tasks.get(this.progress);
    }

    protected void start(ServerLevel world, E entity, long time) {
        this.getRunningTask().tryStart(world, entity, time);
    }

    protected void tick(ServerLevel world, E entity, long time) {
        this.tasks.stream().filter(task -> task.getStatus() == Behavior.Status.RUNNING).forEach(task -> task.tickOrStop(world, entity, time));
    }

    protected void stop(ServerLevel world, E entity, long time) {
        this.progress = 0;
        this.tasks.stream().filter(task -> task.getStatus() == Behavior.Status.RUNNING).forEach(task -> task.doStop(world, entity, time));
    }

    protected boolean canStillUse(ServerLevel world, E entity, long time) {
        if (this.tasks.stream().anyMatch(task -> task.getStatus() == Behavior.Status.RUNNING)) {
            return true;
        }
        if (this.progress < this.tasks.size() - 1) {
            ++this.progress;
            this.getRunningTask().tryStart(world, entity, time);
            return true;
        }
        return false;
    }

    protected boolean timedOut(long time) {
        return false;
    }
}

