/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks;

import com.google.gson.JsonSyntaxException;
import net.conczin.mca.Config;
import net.conczin.mca.util.RegistryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class WanderOrTeleportToTargetTask
extends MoveToTargetSink {
    private static final int SLOWDOWN = 5;
    private int cooldown = 5;

    protected boolean checkExtraStartConditions(ServerLevel serverWorld, Mob mobEntity) {
        if (this.cooldown < 0) {
            this.cooldown = 5;
            return super.checkExtraStartConditions(serverWorld, mobEntity);
        }
        --this.cooldown;
        return false;
    }

    protected void tick(ServerLevel world, Mob entity, long l) {
        if (Config.getInstance().allowVillagerTeleporting) {
            entity.getBrain().getMemoryInternal(MemoryModuleType.WALK_TARGET).ifPresent(walkTarget -> {
                BlockPos targetPos = walkTarget.getTarget().currentBlockPosition();
                if (!targetPos.closerToCenterThan((Position)entity.position(), Config.getInstance().villagerMinTeleportationDistance)) {
                    this.tryTeleport(world, entity, targetPos);
                }
            });
        }
        super.tick(world, entity, l);
    }

    private void tryTeleport(ServerLevel world, Mob entity, BlockPos targetPos) {
        for (int i = 0; i < 10; ++i) {
            int j = this.getRandomInt(entity, -3, 3);
            int k = this.getRandomInt(entity, -1, 1);
            int l = this.getRandomInt(entity, -3, 3);
            boolean bl = this.tryTeleportTo(world, entity, targetPos, targetPos.getX() + j, targetPos.getY() + k, targetPos.getZ() + l);
            if (!bl) continue;
            return;
        }
    }

    private boolean tryTeleportTo(ServerLevel world, Mob entity, BlockPos targetPos, int x, int y, int z) {
        if (Math.abs((double)x - (double)targetPos.getX()) < 2.0 && Math.abs((double)z - (double)targetPos.getZ()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(world, entity, new BlockPos(x, y, z))) {
            return false;
        }
        entity.teleportTo((double)x + 0.5, (double)y, (double)z + 0.5);
        return true;
    }

    private boolean canTeleportTo(ServerLevel world, Mob entity, BlockPos pos) {
        PathType pathNodeType = WalkNodeEvaluator.getPathTypeStatic((Mob)entity, (BlockPos)pos.mutable());
        if (pathNodeType != PathType.WALKABLE) {
            return false;
        }
        if (!this.isAreaSafe(world, pos.below())) {
            return false;
        }
        BlockPos blockPos = pos.subtract((Vec3i)entity.blockPosition());
        return world.noCollision((Entity)entity, entity.getBoundingBox().move(blockPos));
    }

    private int getRandomInt(Mob entity, int min, int max) {
        return entity.getRandom().nextInt(max - min + 1) + min;
    }

    private boolean isAreaSafe(ServerLevel world, BlockPos pos) {
        BlockState aboveState = world.getBlockState(pos);
        ResourceLocation aboveId = BuiltInRegistries.BLOCK.getKey((Object)aboveState.getBlock());
        for (String blockId : Config.getInstance().villagerPathfindingBlacklist) {
            if (blockId.equals(aboveId.toString())) {
                return false;
            }
            if (blockId.charAt(0) != '#') continue;
            ResourceLocation identifier = ResourceLocation.parse((String)blockId.substring(1));
            TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)identifier);
            if (!RegistryHelper.isTagEmpty(tag)) {
                if (!aboveState.is(tag)) continue;
                return false;
            }
            throw new JsonSyntaxException("Unknown block tag in villagerPathfindingBlacklist '" + String.valueOf(identifier) + "'");
        }
        return true;
    }
}

