/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks.chore;

import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.Chore;
import net.conczin.mca.entity.ai.brain.tasks.chore.AbstractChoreTask;
import net.conczin.mca.util.InventoryUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;

public class HuntingTask
extends AbstractChoreTask {
    private int ticks = 0;
    private int nextAction = 0;
    private Animal target = null;

    public HuntingTask() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel world, VillagerEntityMCA villager) {
        return villager.getVillagerBrain().getCurrentJob() == Chore.HUNT && super.checkExtraStartConditions(world, villager);
    }

    protected boolean canStillUse(ServerLevel world, VillagerEntityMCA villager, long time) {
        return this.checkExtraStartConditions(world, villager);
    }

    protected void stop(ServerLevel world, VillagerEntityMCA villager, long time) {
        ItemStack stack = villager.getItemInHand(villager.getDominantHand());
        if (!stack.isEmpty()) {
            villager.setItemInHand(villager.getDominantHand(), ItemStack.EMPTY);
        }
    }

    @Override
    protected void start(ServerLevel world, VillagerEntityMCA villager, long time) {
        super.start(world, villager, time);
        if (!villager.hasItemInSlot(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((Container)villager.getInventory(), stack -> stack.getItem() instanceof SwordItem);
            if (i == -1) {
                this.abandonJobWithMessage("chore.hunting.nosword");
            } else {
                ItemStack stack2 = villager.getInventory().getItem(i);
                villager.setItemInHand(villager.getDominantHand(), stack2);
            }
        }
    }

    @Override
    protected void tick(ServerLevel world, VillagerEntityMCA villager, long time) {
        super.tick(world, villager, time);
        if (!InventoryUtils.contains((Container)villager.getInventory(), SwordItem.class) && !villager.hasItemInSlot(villager.getDominantSlot())) {
            this.abandonJobWithMessage("chore.hunting.nosword");
        } else if (!villager.hasItemInSlot(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((Container)villager.getInventory(), stack -> stack.getItem() instanceof SwordItem);
            ItemStack stack2 = villager.getInventory().getItem(i);
            villager.setItemInHand(villager.getDominantHand(), stack2);
        }
        if (this.target == null) {
            ++this.ticks;
            if (this.ticks >= this.nextAction) {
                this.ticks = 0;
                if ((double)villager.level().random.nextFloat() >= 0.0) {
                    villager.level().getEntitiesOfClass(Animal.class, villager.getBoundingBox().inflate(15.0, 3.0, 15.0)).stream().filter(a -> !(a instanceof TamableAnimal)).filter(a -> !a.isBaby()).min(Comparator.comparingDouble(arg_0 -> ((VillagerEntityMCA)villager).distanceToSqr(arg_0))).ifPresent(animal -> {
                        this.target = animal;
                        villager.moveTowards(this.target.blockPosition(), 1.0f);
                    });
                }
                this.nextAction = 50;
                if (this.target == null) {
                    this.failedTicks = 100;
                }
            }
        } else {
            villager.moveTowards(this.target.blockPosition());
            if (this.target.isDeadOrDying()) {
                villager.level().getEntitiesOfClass(ItemEntity.class, villager.getBoundingBox().inflate(15.0, 3.0, 15.0)).forEach(item -> {
                    villager.getInventory().addItem(item.getItem());
                    item.discard();
                });
                this.target = null;
            } else if (villager.distanceToSqr((Entity)this.target) <= 12.25) {
                villager.moveTowards(this.target.blockPosition());
                villager.swing(villager.getDominantHand());
                this.target.hurt(world.damageSources().mobAttack((LivingEntity)villager), 6.0f);
                villager.getMainHandItem().hurtAndBreak(1, (LivingEntity)villager, EquipmentSlot.MAINHAND);
            }
        }
    }
}

