/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.chatAI.inworldAIModules;

import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.Relationship;
import net.conczin.mca.entity.ai.chatAI.inworldAIModules.api.Interaction;
import net.conczin.mca.entity.ai.chatAI.inworldAIModules.api.TriggerEvent;
import net.conczin.mca.entity.ai.relationship.CompassionateEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class RelationshipModule {
    public void updateRelationship(Interaction interaction, ServerPlayer player, VillagerEntityMCA villager) {
        Interaction.RelationshipUpdate update = interaction.relationshipUpdate();
        int weightedTotal = update.trust() + update.respect() + update.familiar() + update.flirtatious() + update.attraction();
        int heartsUpdate = weightedTotal / 10;
        villager.getVillagerBrain().rewardHearts(player, heartsUpdate);
    }

    public TriggerEvent.Parameter getRelationshipTriggerParameter(ServerPlayer player, VillagerEntityMCA villager) {
        return new TriggerEvent.Parameter("relationshipStatus", this.getRelationshipStatus(player, villager).name());
    }

    private RelationshipStatus getRelationshipStatus(ServerPlayer player, VillagerEntityMCA villager) {
        if (Relationship.IS_ENGAGED.test((CompassionateEntity<?>)villager, (Entity)player) || Relationship.IS_MARRIED.test((CompassionateEntity<?>)villager, (Entity)player)) {
            return RelationshipStatus.LIFE_PARTNER;
        }
        if (Relationship.IS_PROMISED.test((CompassionateEntity<?>)villager, (Entity)player)) {
            return RelationshipStatus.RELATIONSHIP;
        }
        int heartLevel = villager.getVillagerBrain().getMemoriesForPlayer((Player)player).getHearts();
        RelationshipStatus returnStatus = RelationshipStatus.UNKNOWN;
        for (RelationshipStatus status : RelationshipStatus.values()) {
            if (!status.hasStatus(heartLevel)) continue;
            returnStatus = status;
        }
        return returnStatus;
    }

    private static enum RelationshipStatus {
        UNKNOWN(Integer.MIN_VALUE),
        ARCHENEMY(Integer.MIN_VALUE),
        ENEMY(-75),
        ACQUAINTANCE(-15),
        FRIEND(25),
        CLOSE_FRIEND(100),
        DATE(Integer.MAX_VALUE),
        RELATIONSHIP(Integer.MAX_VALUE),
        LIFE_PARTNER(Integer.MAX_VALUE);

        private final int heartThreshold;

        private RelationshipStatus(int heartThreshold) {
            this.heartThreshold = heartThreshold;
        }

        public boolean hasStatus(int hearts) {
            return hearts > this.heartThreshold;
        }
    }
}

