/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.goal;

import net.conczin.mca.entity.GrimReaperEntity;
import net.conczin.mca.entity.ReaperAttackState;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class GrimReaperMeleeGoal
extends Goal {
    private static final int COOLDOWN = 150;
    private final GrimReaperEntity reaper;
    private int blockDuration;
    private int attackDuration;
    private int retreatDuration;
    private int lastAttack = 0;

    public GrimReaperMeleeGoal(GrimReaperEntity reaper) {
        this.reaper = reaper;
    }

    public boolean canUse() {
        LivingEntity entityToAttack = this.reaper.getTarget();
        return entityToAttack != null && this.reaper.distanceToSqr((Entity)entityToAttack) <= 144.0 && this.reaper.tickCount > this.lastAttack + 150 && this.reaper.getAttackState() != ReaperAttackState.REST;
    }

    public boolean canContinueToUse() {
        return this.retreatDuration > 0 && this.reaper.getAttackState() != ReaperAttackState.REST;
    }

    public boolean isInterruptable() {
        return false;
    }

    public void start() {
        this.blockDuration = 50;
        this.attackDuration = 100;
        this.retreatDuration = 20;
        this.lastAttack = this.reaper.tickCount;
    }

    public void stop() {
        super.stop();
        this.reaper.setAttackState(ReaperAttackState.IDLE);
    }

    private void curse() {
        Player player;
        LivingEntity entityToAttack = this.reaper.getTarget();
        if (entityToAttack instanceof Player && (player = (Player)entityToAttack).isBlocking()) {
            double dX = this.reaper.getX() - player.getX();
            double dZ = this.reaper.getZ() - player.getZ();
            this.reaper.teleportTo(player.getX() - dX * 2.0, player.getY() + 2.0, this.reaper.getZ() - dZ * 2.0);
            if (!this.reaper.level().isClientSide && this.reaper.getRandom().nextFloat() >= 0.2f) {
                int currentItem = player.getInventory().selected;
                int randomItem = this.reaper.getRandom().nextInt(9);
                ItemStack currentItemStack = player.getInventory().getItem(currentItem);
                ItemStack randomItemStack = player.getInventory().getItem(randomItem);
                player.getInventory().setItem(currentItem, randomItemStack);
                player.getInventory().setItem(randomItem, currentItemStack);
                entityToAttack.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200));
            }
        }
    }

    public void tick() {
        if (this.reaper.getAttackState() == ReaperAttackState.REST) {
            return;
        }
        LivingEntity entityToAttack = this.reaper.getTarget();
        if (entityToAttack == null) {
            this.retreatDuration = 0;
            return;
        }
        if (this.blockDuration > 0) {
            --this.blockDuration;
            this.reaper.setAttackState(ReaperAttackState.BLOCK);
            if (this.blockDuration == 0) {
                this.curse();
            }
            if (this.reaper.distanceToSqr((Entity)entityToAttack) <= 4.0) {
                int rX = this.reaper.getRandom().nextInt(10);
                int rY = this.reaper.getRandom().nextInt(6);
                int rZ = this.reaper.getRandom().nextInt(10);
                this.reaper.teleportTo(this.reaper.getX() - 5.0 + (double)rX, this.reaper.getY() + (double)rY, this.reaper.getZ() - 5.0 + (double)rZ);
                this.reaper.getNavigation().stop();
            }
            Vec3 deltaMovement = this.reaper.getDeltaMovement();
            this.reaper.setDeltaMovement(new Vec3(deltaMovement.x, 0.05, deltaMovement.z));
        } else if (this.attackDuration > 0) {
            --this.attackDuration;
            this.reaper.setAttackState(ReaperAttackState.PRE);
            Vec3 dir = entityToAttack.position().subtract(this.reaper.position()).normalize().scale(0.15);
            this.reaper.push(dir.x, dir.y, dir.z);
            if (this.reaper.distanceToSqr((Entity)entityToAttack) <= 1.0) {
                this.reaper.swing(InteractionHand.MAIN_HAND);
                this.attackDuration = 0;
                entityToAttack.hurt(this.reaper.level().damageSources().mobAttack((LivingEntity)this.reaper), (float)this.reaper.getAttributeValue(Attributes.ATTACK_DAMAGE));
                entityToAttack.addEffect(new MobEffectInstance(MobEffects.WITHER, 200));
            }
        } else {
            --this.retreatDuration;
            this.reaper.setAttackState(ReaperAttackState.POST);
            Vec3 dir = entityToAttack.position().subtract(this.reaper.position()).normalize().scale(-0.1);
            this.reaper.setDeltaMovement(dir.x, dir.y, dir.z);
        }
    }
}

