/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.goal;

import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class GrimReaperTargetGoal
extends Goal {
    private final TargetingConditions attackTargeting = TargetingConditions.forCombat().range(64.0);
    private final PathfinderMob mob;
    private int nextScanTick = 20;

    public GrimReaperTargetGoal(PathfinderMob mob) {
        this.mob = mob;
    }

    public boolean canUse() {
        if (this.nextScanTick > 0) {
            --this.nextScanTick;
        } else {
            this.nextScanTick = 20;
            List list = this.mob.level().getNearbyPlayers(this.attackTargeting, (LivingEntity)this.mob, this.mob.getBoundingBox().inflate(48.0, 64.0, 48.0));
            if (!list.isEmpty()) {
                list.sort((a, b) -> Double.compare(b.getY(), a.getY()));
                for (Player player : list) {
                    if (!this.mob.canAttack((LivingEntity)player, TargetingConditions.DEFAULT)) continue;
                    this.mob.setTarget((LivingEntity)player);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.mob.getTarget() != null;
    }
}

