/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.item;

import java.util.Comparator;
import java.util.Optional;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.relationship.AgeState;
import net.conczin.mca.item.SpecialCaseGift;
import net.conczin.mca.util.WorldUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class MatchmakersRingItem
extends Item
implements SpecialCaseGift {
    public MatchmakersRingItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean handle(ServerPlayer player, VillagerEntityMCA villager) {
        if (player.getMainHandItem().getCount() < 2) {
            villager.sendChatMessage((Player)player, "interaction.matchmaker.fail.needtwo", new Object[0]);
            return false;
        }
        if (villager.getRelationships().isMarried() || villager.getAgeState() != AgeState.ADULT) {
            villager.sendChatMessage((Player)player, "interaction.matchmaker.fail.married", new Object[0]);
            return false;
        }
        Optional<VillagerEntityMCA> target = WorldUtils.getCloseEntities(villager.level(), (Entity)villager, 5.0).stream().filter(v -> v != villager && v instanceof VillagerEntityMCA).map(VillagerEntityMCA.class::cast).filter(v -> !v.isBaby() && !v.getRelationships().isMarried()).filter(v -> !v.getRelationships().getFamilyEntry().isRelative(villager.getUUID())).filter(villager::canBeAttractedTo).min(Comparator.comparingDouble(arg_0 -> ((VillagerEntityMCA)villager).distanceTo(arg_0)));
        if (target.isEmpty()) {
            villager.sendChatMessage((Player)player, "interaction.matchmaker.fail.novillagers", new Object[0]);
            return false;
        }
        VillagerEntityMCA spouse = target.get();
        villager.getRelationships().marry((Entity)spouse);
        spouse.getRelationships().marry((Entity)villager);
        player.level().broadcastEntityEvent((Entity)villager, (byte)12);
        if (!player.isCreative()) {
            player.getMainHandItem().shrink(1);
        }
        return true;
    }
}

