/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.item;

import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.item.TooltippedItem;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.PlayerDataMessage;
import net.conczin.mca.server.world.data.FamilyTree;
import net.conczin.mca.server.world.data.FamilyTreeNode;
import net.conczin.mca.server.world.data.PlayerSaveData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PotionOfMetamorphosisItem
extends TooltippedItem {
    private final Gender gender;

    public PotionOfMetamorphosisItem(Item.Properties properties, Gender gender) {
        super(properties);
        this.gender = gender;
    }

    public final InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerSaveData data = PlayerSaveData.get(serverPlayer);
            CompoundTag villagerData = data.getEntityData();
            villagerData.putInt("Gender", this.gender.ordinal());
            data.setEntityData(villagerData);
            this.common((Entity)serverPlayer);
            serverPlayer.serverLevel().players().forEach(p -> Network.sendToPlayer(new PlayerDataMessage(player.getUUID(), villagerData), p));
            ItemStack stack = player.getItemInHand(hand);
            stack.shrink(1);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(world, player, hand);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity instanceof VillagerLike) {
            VillagerLike villager = (VillagerLike)entity;
            if (!entity.level().isClientSide) {
                villager.getGenetics().setGender(this.gender);
                this.common((Entity)entity);
                stack.shrink(1);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.CONSUME;
    }

    private void common(Entity entity) {
        entity.playSound(SoundEvents.ZOMBIE_VILLAGER_CONVERTED, 1.0f, 1.0f);
        FamilyTree tree = FamilyTree.get((ServerLevel)entity.level());
        FamilyTreeNode entry = tree.getOrCreate(entity);
        entry.setGender(this.gender);
    }
}

