/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.item;

import java.util.List;
import java.util.UUID;
import net.conczin.mca.Config;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.OpenGuiRequest;
import net.conczin.mca.registry.DataComponentsMCA;
import net.conczin.mca.server.world.data.VillagerTrackerManager;
import net.conczin.mca.util.localization.FlowingText;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class VillagerTrackerItem
extends Item {
    public VillagerTrackerItem(Item.Properties settings) {
        super(settings);
    }

    public final InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Network.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.VILLAGER_TRACKER), serverPlayer);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (world.getGameTime() % (long)Config.getInstance().trackVillagerPositionEveryNTicks == 0L && stack.has(DataComponentsMCA.TRACKER_UUID)) {
                UUID uuid = (UUID)stack.get(DataComponentsMCA.TRACKER_UUID);
                GlobalPos pos = VillagerTrackerManager.get(serverWorld).get(uuid);
                if (pos != null) {
                    stack.set(DataComponentsMCA.TRACKER_POS, (Object)pos);
                }
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (stack.has(DataComponentsMCA.TRACKER_NAME)) {
            LocalPlayer player;
            tooltip.add((Component)Component.translatable((String)(this.getDescriptionId(stack) + ".active"), (Object[])new Object[]{stack.get(DataComponentsMCA.TRACKER_NAME)}).withStyle(ChatFormatting.GREEN));
            GlobalPos pos = (GlobalPos)stack.get(DataComponentsMCA.TRACKER_POS);
            if (pos != null && (player = Minecraft.getInstance().player) != null) {
                int precision = 5;
                int distance = (int)Math.sqrt(pos.pos().distToCenterSqr((Position)player.position())) / precision * precision;
                tooltip.add((Component)Component.translatable((String)(this.getDescriptionId(stack) + ".distance"), (Object[])new Object[]{distance}).withStyle(ChatFormatting.ITALIC));
            }
        }
        tooltip.addAll(FlowingText.wrap((Component)Component.translatable((String)(this.getDescriptionId(stack) + ".tooltip")).withStyle(ChatFormatting.GRAY), 160));
    }
}

