/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.mixin;

import net.conczin.mca.registry.CriterionMCA;
import net.conczin.mca.registry.ItemsMCA;
import net.conczin.mca.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Goat.class})
public abstract class MixinGoat
extends Animal {
    protected MixinGoat(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"getMilkingSound()Lnet/minecraft/sounds/SoundEvent;"}, at={@At(value="HEAD")})
    protected void mca$injectGetMilkingSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (!this.level().isClientSide && this.level().isRaining()) {
            WitherSkeleton ancientCultist;
            long time = this.level().getDayTime() % 24000L;
            BlockPos pos = this.blockPosition();
            if (time > 16000L && time < 20000L && ((Biome)this.level().getBiome(pos).value()).coldEnoughToSnow(pos) && SpawnPlacements.isSpawnPositionOk((EntityType)EntityType.WITHER_SKELETON, (LevelReader)this.level(), (BlockPos)pos) && (ancientCultist = (WitherSkeleton)EntityType.WITHER_SKELETON.create(this.level())) != null) {
                ancientCultist.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                WorldUtils.spawnEntity(this.level(), (Mob)ancientCultist, MobSpawnType.EVENT);
                ancientCultist.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.GOLDEN_HELMET));
                ancientCultist.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.GOLDEN_CHESTPLATE));
                ancientCultist.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.GOLDEN_LEGGINGS));
                ancientCultist.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.GOLDEN_BOOTS));
                ancientCultist.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.GOLDEN_SWORD));
                ancientCultist.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)ItemsMCA.BOOK_CULT_ANCIENT));
                ancientCultist.setDropChance(EquipmentSlot.OFFHAND, 1.0f);
                ancientCultist.setCustomName((Component)Component.translatable((String)"entity.mca.ancient_cultist"));
                ((ServerLevel)this.level()).players().stream().filter(p -> p.distanceTo((Entity)this) < 30.0f).forEach(p -> CriterionMCA.GENERIC_EVENT.trigger((ServerPlayer)p, "ancient_cultists"));
                this.kill();
                this.level().setSkyFlashTime(10);
                LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
                if (bolt != null) {
                    bolt.setVisualOnly(true);
                    bolt.absMoveTo((double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f));
                    this.level().addFreshEntity((Entity)bolt);
                }
            }
        }
    }
}

