/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.mixin.client;

import java.util.Map;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.CommonSpeechManager;
import net.conczin.mca.entity.ai.DialogueType;
import net.conczin.mca.util.localization.PooledTranslationStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.locale.Language;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientLanguage.class}, priority=990)
abstract class MixinClientLanguage
extends Language {
    @Shadow
    @Final
    private Map<String, String> storage;
    @Unique
    private PooledTranslationStorage mca$pool;

    MixinClientLanguage() {
    }

    @Shadow
    @NotNull
    public abstract String getOrDefault(String var1, String var2);

    @Unique
    private PooledTranslationStorage mca$getPool() {
        if (this.mca$pool == null) {
            this.mca$pool = new PooledTranslationStorage(this.storage);
            MCA.storage = this.storage;
            MCA.language = Minecraft.getInstance().options.languageCode;
        }
        return this.mca$pool;
    }

    @Inject(method={"getOrDefault"}, at={@At(value="HEAD")}, cancellable=true)
    private void mca$injectGetOrDefault(String key, String fallback, CallbackInfoReturnable<String> info) {
        String modifiedKey = DialogueType.applyFallback(key);
        Tuple<String, String> unpooled = this.mca$getPool().get(modifiedKey);
        if (unpooled != null) {
            CommonSpeechManager.INSTANCE.lastResolvedKey = (String)unpooled.getA();
            if (this.storage.containsKey(unpooled.getA()) && !this.storage.get(unpooled.getA()).equals(unpooled.getB())) {
                info.setReturnValue((Object)((String)unpooled.getB()));
            } else {
                info.setReturnValue((Object)this.getOrDefault((String)unpooled.getA(), fallback));
            }
        } else if (!key.equals(modifiedKey)) {
            info.setReturnValue((Object)this.getOrDefault(modifiedKey, fallback));
        }
    }

    @Inject(method={"has(Ljava/lang/String;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void mca$injectHas(String key, CallbackInfoReturnable<Boolean> info) {
        if (this.mca$getPool().contains(key)) {
            info.setReturnValue((Object)true);
        }
    }
}

