/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.network.c2s;

import java.util.stream.Stream;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.network.HandleablePayload;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.GetFamilyResponse;
import net.conczin.mca.server.world.data.PlayerSaveData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Mob;

public record GetFamilyRequest() implements HandleablePayload
{
    public static final CustomPacketPayload.Type<GetFamilyRequest> TYPE = new CustomPacketPayload.Type(MCA.locate("get_family_request"));
    public static final StreamCodec<FriendlyByteBuf, GetFamilyRequest> STREAM_CODEC = StreamCodec.unit((Object)new GetFamilyRequest());

    @Override
    public void handleServer(ServerPlayer player) {
        CompoundTag familyData = new CompoundTag();
        PlayerSaveData playerData = PlayerSaveData.get(player);
        Stream.concat(playerData.getFamilyEntry().getAllRelatives(4), playerData.getPartnerUUID().stream()).distinct().map(uuid -> player.serverLevel().getEntity(uuid)).filter(e -> e instanceof VillagerLike).limit(100L).forEach(e -> {
            CompoundTag nbt = new CompoundTag();
            ((Mob)e).addAdditionalSaveData(nbt);
            nbt.remove("Brain");
            nbt.remove("Memories");
            nbt.remove("Inventory");
            familyData.put(e.getUUID().toString(), (Tag)nbt);
        });
        Network.sendToPlayer(new GetFamilyResponse(familyData), player);
    }

    public CustomPacketPayload.Type<GetFamilyRequest> type() {
        return TYPE;
    }
}

