/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.network.c2s;

import java.util.Optional;
import java.util.UUID;
import net.conczin.mca.MCA;
import net.conczin.mca.network.HandleablePayload;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.GetVillagerResponse;
import net.conczin.mca.server.world.data.FamilyTree;
import net.conczin.mca.server.world.data.FamilyTreeNode;
import net.conczin.mca.server.world.data.PlayerSaveData;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public record GetVillagerRequest(UUID id) implements HandleablePayload
{
    public static final CustomPacketPayload.Type<GetVillagerRequest> TYPE = new CustomPacketPayload.Type(MCA.locate("get_villager_request"));
    public static final StreamCodec<FriendlyByteBuf, GetVillagerRequest> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, GetVillagerRequest::id, GetVillagerRequest::new);

    private static void storeNode(CompoundTag data, Optional<FamilyTreeNode> entry, String prefix) {
        if (entry.isPresent()) {
            data.putString("FamilyTree" + prefix + "Name", entry.get().getName());
        } else {
            data.putString("FamilyTree" + prefix + "Name", "");
        }
    }

    public static CompoundTag getVillagerData(Entity e) {
        CompoundTag data;
        if (e instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)e;
            data = PlayerSaveData.get(serverPlayer).getEntityData();
        } else if (e instanceof LivingEntity) {
            data = new CompoundTag();
            e.save(data);
        } else {
            return null;
        }
        FamilyTree tree = FamilyTree.get((ServerLevel)e.level());
        FamilyTreeNode entry = tree.getOrCreate(e);
        GetVillagerRequest.storeNode(data, tree.getOrEmpty(entry.partner()), "Spouse");
        GetVillagerRequest.storeNode(data, tree.getOrEmpty(entry.father()), "Father");
        GetVillagerRequest.storeNode(data, tree.getOrEmpty(entry.mother()), "Mother");
        return data;
    }

    @Override
    public void handleServer(ServerPlayer player) {
        Entity e = player.serverLevel().getEntity(this.id);
        CompoundTag villagerData = GetVillagerRequest.getVillagerData(e);
        if (villagerData != null) {
            Network.sendToPlayer(new GetVillagerResponse(villagerData), player);
        }
    }

    public CustomPacketPayload.Type<GetVillagerRequest> type() {
        return TYPE;
    }
}

