/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.network.c2s;

import java.util.UUID;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.network.HandleablePayload;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public record InteractionCloseRequest(UUID villagerUUID) implements HandleablePayload
{
    public static final CustomPacketPayload.Type<InteractionCloseRequest> TYPE = new CustomPacketPayload.Type(MCA.locate("interaction_close_request"));
    public static final StreamCodec<FriendlyByteBuf, InteractionCloseRequest> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, InteractionCloseRequest::villagerUUID, InteractionCloseRequest::new);

    @Override
    public void handleServer(ServerPlayer player) {
        Entity v = player.serverLevel().getEntity(this.villagerUUID);
        if (v instanceof VillagerEntityMCA) {
            VillagerEntityMCA villager = (VillagerEntityMCA)v;
            villager.getInteractions().stopInteracting();
        }
    }

    public CustomPacketPayload.Type<InteractionCloseRequest> type() {
        return TYPE;
    }
}

