/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.network.c2s;

import java.util.UUID;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.network.HandleablePayload;
import net.conczin.mca.resources.Dialogues;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public record InteractionDialogueMessage(UUID villagerUUID, String question, String answer) implements HandleablePayload
{
    public static final CustomPacketPayload.Type<InteractionDialogueMessage> TYPE = new CustomPacketPayload.Type(MCA.locate("interaction_dialogue"));
    public static final StreamCodec<FriendlyByteBuf, InteractionDialogueMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, InteractionDialogueMessage::villagerUUID, (StreamCodec)ByteBufCodecs.STRING_UTF8, InteractionDialogueMessage::question, (StreamCodec)ByteBufCodecs.STRING_UTF8, InteractionDialogueMessage::answer, InteractionDialogueMessage::new);

    @Override
    public void handleServer(ServerPlayer player) {
        Entity v = player.serverLevel().getEntity(this.villagerUUID);
        if (v instanceof VillagerEntityMCA) {
            VillagerEntityMCA villager = (VillagerEntityMCA)v;
            Dialogues.getInstance().selectAnswer(villager, player, this.question, this.answer);
        }
    }

    public CustomPacketPayload.Type<InteractionDialogueMessage> type() {
        return TYPE;
    }
}

