/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.network.c2s;

import java.util.UUID;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.network.HandleablePayload;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public record InteractionVillagerMessage(String command, UUID villagerUUID) implements HandleablePayload
{
    public static final CustomPacketPayload.Type<InteractionVillagerMessage> TYPE = new CustomPacketPayload.Type(MCA.locate("interaction_villager"));
    public static final StreamCodec<FriendlyByteBuf, InteractionVillagerMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, InteractionVillagerMessage::command, (StreamCodec)UUIDUtil.STREAM_CODEC, InteractionVillagerMessage::villagerUUID, InteractionVillagerMessage::new);

    @Override
    public void handleServer(ServerPlayer player) {
        VillagerLike villager;
        Entity v = player.serverLevel().getEntity(this.villagerUUID);
        if (v instanceof VillagerLike && (villager = (VillagerLike)v).getInteractions().handle(player, this.command)) {
            villager.getInteractions().stopInteracting();
        }
    }

    public CustomPacketPayload.Type<InteractionVillagerMessage> type() {
        return TYPE;
    }
}

