/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.registry;

import java.util.HashMap;
import java.util.Map;
import net.conczin.mca.MCA;
import net.conczin.mca.block.InfernalFlameBlock;
import net.conczin.mca.block.TombstoneBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.Vec3;

public interface BlocksMCA {
    public static final Map<String, Block> BLOCKS = new HashMap<String, Block>();
    public static final Block ROSE_GOLD_BLOCK = BlocksMCA.register("rose_gold_block", new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GOLD_BLOCK)));
    public static final Block INFERNAL_FLAME = BlocksMCA.register("infernal_flame", (Block)new InfernalFlameBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SOUL_FIRE)));
    public static final Block GRAVELLING_HEADSTONE = BlocksMCA.register("gravelling_headstone", (Block)new TombstoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion(), 100, 50, new Vec3(0.0, -25.0, 40.0), -90.0f, true, TombstoneBlock.GRAVELLING_SHAPE));
    public static final Block UPRIGHT_HEADSTONE = BlocksMCA.register("upright_headstone", (Block)new TombstoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion(), 70, 30, new Vec3(0.0, -30.0, -8.0), 0.0f, true, TombstoneBlock.UPRIGHT_SHAPE));
    public static final Block SLANTED_HEADSTONE = BlocksMCA.register("slanted_headstone", (Block)new TombstoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion(), 90, 15, new Vec3(0.0, -12.0, 22.0), -72.5f, true, TombstoneBlock.SLANTED_SHAPE));
    public static final Block CROSS_HEADSTONE = BlocksMCA.register("cross_headstone", (Block)new TombstoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion(), 80, 15, new Vec3(0.0, -13.0, 15.0), -45.0f, true, TombstoneBlock.CROSS_SHAPE));
    public static final Block WALL_HEADSTONE = BlocksMCA.register("wall_headstone", (Block)new TombstoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion(), 100, 15, new Vec3(0.0, -25.0, 40.0), 0.0f, false, TombstoneBlock.WALL_SHAPE));
    public static final Block COBBLESTONE_UPRIGHT_HEADSTONE = BlocksMCA.register("cobblestone_upright_headstone", (Block)new TombstoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE).noOcclusion(), 70, 30, new Vec3(0.0, -30.0, -8.0), 0.0f, true, TombstoneBlock.UPRIGHT_SHAPE));
    public static final Block COBBLESTONE_SLANTED_HEADSTONE = BlocksMCA.register("cobblestone_slanted_headstone", (Block)new TombstoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE).noOcclusion(), 90, 15, new Vec3(0.0, -12.0, 22.0), -72.5f, true, TombstoneBlock.SLANTED_SHAPE));
    public static final Block WOODEN_UPRIGHT_HEADSTONE = BlocksMCA.register("wooden_upright_headstone", (Block)new TombstoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD).noOcclusion(), 70, 30, new Vec3(0.0, -30.0, -8.0), 0.0f, true, TombstoneBlock.UPRIGHT_SHAPE));
    public static final Block WOODEN_SLANTED_HEADSTONE = BlocksMCA.register("wooden_slanted_headstone", (Block)new TombstoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD).noOcclusion(), 90, 15, new Vec3(0.0, -12.0, 22.0), -72.5f, true, TombstoneBlock.SLANTED_SHAPE));
    public static final Block GOLDEN_UPRIGHT_HEADSTONE = BlocksMCA.register("golden_upright_headstone", (Block)new TombstoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE).noOcclusion(), 70, 30, new Vec3(0.0, -30.0, -8.0), 0.0f, true, TombstoneBlock.UPRIGHT_SHAPE));
    public static final Block GOLDEN_SLANTED_HEADSTONE = BlocksMCA.register("golden_slanted_headstone", (Block)new TombstoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE).noOcclusion(), 90, 15, new Vec3(0.0, -12.0, 22.0), -72.5f, true, TombstoneBlock.SLANTED_SHAPE));
    public static final Block DEEPSLATE_UPRIGHT_HEADSTONE = BlocksMCA.register("deepslate_upright_headstone", (Block)new TombstoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE).noOcclusion(), 70, 30, new Vec3(0.0, -30.0, -8.0), 0.0f, true, TombstoneBlock.UPRIGHT_SHAPE));
    public static final Block DEEPSLATE_SLANTED_HEADSTONE = BlocksMCA.register("deepslate_slanted_headstone", (Block)new TombstoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE).noOcclusion(), 90, 15, new Vec3(0.0, -12.0, 22.0), -72.5f, true, TombstoneBlock.SLANTED_SHAPE));

    public static Block register(String name, Block block) {
        BLOCKS.put(name, block);
        return block;
    }

    public static void registerBlocks(MCA.RegisterHelper<Block> helper) {
        BLOCKS.forEach((name, block) -> helper.register(MCA.locate(name), (Block)block));
    }
}

