/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.CribEntity;
import net.conczin.mca.entity.GrimReaperEntity;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ZombieVillagerEntityMCA;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;

public interface EntitiesMCA {
    public static final Map<ResourceLocation, EntityType<?>> ENTITIES = new HashMap();
    public static final Map<EntityType<? extends LivingEntity>, AttributeSupplier.Builder> ATTRIBUTES = new HashMap<EntityType<? extends LivingEntity>, AttributeSupplier.Builder>();
    public static final EntityType<VillagerEntityMCA> MALE_VILLAGER = EntitiesMCA.register("male_villager", EntityType.Builder.of((t, w) -> new VillagerEntityMCA((EntityType<VillagerEntityMCA>)t, w, Gender.MALE), (MobCategory)MobCategory.MISC).sized(0.6f, 2.0f), VillagerEntityMCA::createAttributes);
    public static final EntityType<VillagerEntityMCA> FEMALE_VILLAGER = EntitiesMCA.register("female_villager", EntityType.Builder.of((t, w) -> new VillagerEntityMCA((EntityType<VillagerEntityMCA>)t, w, Gender.FEMALE), (MobCategory)MobCategory.MISC).sized(0.6f, 2.0f), VillagerEntityMCA::createAttributes);
    public static final EntityType<ZombieVillagerEntityMCA> MALE_ZOMBIE_VILLAGER = EntitiesMCA.register("male_zombie_villager", EntityType.Builder.of((t, w) -> new ZombieVillagerEntityMCA((EntityType<? extends ZombieVillager>)t, w, Gender.MALE), (MobCategory)MobCategory.MONSTER).sized(0.6f, 2.0f), Zombie::createAttributes);
    public static final EntityType<ZombieVillagerEntityMCA> FEMALE_ZOMBIE_VILLAGER = EntitiesMCA.register("female_zombie_villager", EntityType.Builder.of((t, w) -> new ZombieVillagerEntityMCA((EntityType<? extends ZombieVillager>)t, w, Gender.FEMALE), (MobCategory)MobCategory.MONSTER).sized(0.6f, 2.0f), Zombie::createAttributes);
    public static final EntityType<GrimReaperEntity> GRIM_REAPER = EntitiesMCA.register("grim_reaper", EntityType.Builder.of(GrimReaperEntity::new, (MobCategory)MobCategory.MONSTER).sized(1.0f, 2.6f).fireImmune(), GrimReaperEntity::createAttributes);
    public static final EntityType<CribEntity> CRIB = EntitiesMCA.register("crib", EntityType.Builder.of(CribEntity::new, (MobCategory)MobCategory.MISC).sized(1.2f, 1.0f).fireImmune());

    public static <T extends LivingEntity> EntityType<T> register(String name, EntityType.Builder<T> builder, Supplier<AttributeSupplier.Builder> attributes) {
        ResourceLocation id = MCA.locate(name);
        EntityType entity = builder.build(id.toString());
        ATTRIBUTES.put((EntityType<? extends LivingEntity>)entity, attributes.get());
        ENTITIES.put(id, entity);
        return entity;
    }

    public static <T extends Entity> EntityType<T> register(String name, EntityType.Builder<T> builder) {
        ResourceLocation id = MCA.locate(name);
        EntityType entity = builder.build(id.toString());
        ENTITIES.put(id, entity);
        return entity;
    }

    public static void registerEntities(MCA.RegisterHelper<EntityType<?>> helper) {
        ENTITIES.forEach(helper::register);
    }

    public static void registerAttributes(MCA.AttributeRegisterHelper helper) {
        ATTRIBUTES.forEach(helper::register);
    }
}

